#!/usr/bin/env python
"""
Copyright 2011 Wordnik, Inc.
 
    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0
 
    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

class WordDefinitionsInput:
    """

    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """

    def __init__(self):
        self.swaggerTypes = {
            'word': 'str',
            'limit': 'str',
            'partOfSpeech': 'str',
            'includeRelated': 'str',
            'sourceDictionaries': 'List<Str>',
            'useCanonical': 'str',
            'includeTags': 'str'
        }



        # Word to return definitions for
        self.word = None # str


        # Maximum number of results to return
        self.limit = None # str


        # CSV list of part-of-speech types
        self.partOfSpeech = None # str


        # Return related words with definitions
        self.includeRelated = None # str


        # If 'all' is received, results are returned from all sources. If multiple values are received (e.g. 'century,wiktionary'), results are returned from the first specified dictionary that has definitions. If left blank, results are returned from the first dictionary that has definitions. By default, dictionaries are searched in this order: ahd, wiktionary, webster, century, wordnet
        self.sourceDictionaries = None # List<Str>


        # If true will try to return the correct word root ('cats' -> 'cat'). If false returns exactly what was requested.
        self.useCanonical = None # str


        # Return a closed set of XML tags in response
        self.includeTags = None # str

