#!/usr/bin/env python
"""
WordAPI.py
Copyright 2012 Wordnik, Inc.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

NOTE: This class is auto generated by the swagger code generator program. Do not edit the class manually.
"""
import sys
import os

from models import *


class AccountApi(object):

    def __init__(self, apiClient):
      self.apiClient = apiClient

    
    def authenticate(self, username, password, **kwargs):
        """Authenticates a User

        Args:
            username, str: A confirmed Wordnik username (required)
            password, str: The user's password (required)
            
        Returns: AuthenticationToken
        """

        allParams = ['username', 'password']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method authenticate" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/account.{format}/authenticate/{username}'
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('password' in params):
            queryParams['password'] = self.apiClient.toPathValue(params['password'])
        if ('username' in params):
            replacement = str(self.apiClient.toPathValue(params['username']))
            resourcePath = resourcePath.replace('{' + 'username' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'AuthenticationToken')
        return responseObject
        
        
    def authenticatePost(self, username, body, **kwargs):
        """Authenticates a user

        Args:
            username, str: A confirmed Wordnik username (required)
            body, str: The user's password (required)
            
        Returns: AuthenticationToken
        """

        allParams = ['username', 'body']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method authenticatePost" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/account.{format}/authenticate/{username}'
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'POST'

        queryParams = {}
        headerParams = {}

        if ('username' in params):
            replacement = str(self.apiClient.toPathValue(params['username']))
            resourcePath = resourcePath.replace('{' + 'username' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'AuthenticationToken')
        return responseObject
        
        
    def getWordListsForLoggedInUser(self, auth_token, **kwargs):
        """Fetches WordList objects for the logged-in user.

        Args:
            auth_token, str: auth_token of logged-in user (required)
            skip, int: Results to skip (optional)
            limit, int: Maximum number of results to return (optional)
            
        Returns: list[WordList]
        """

        allParams = ['auth_token', 'skip', 'limit']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method getWordListsForLoggedInUser" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/account.{format}/wordLists'
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('skip' in params):
            queryParams['skip'] = self.apiClient.toPathValue(params['skip'])
        if ('limit' in params):
            queryParams['limit'] = self.apiClient.toPathValue(params['limit'])
        if ('auth_token' in params):
            headerParams['auth_token'] = params['auth_token']
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'list[WordList]')
        return responseObject
        
        
    def getApiTokenStatus(self, **kwargs):
        """Returns usage statistics for the API account.

        Args:
            api_key, str: Wordnik authentication token (optional)
            
        Returns: ApiTokenStatus
        """

        allParams = ['api_key']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method getApiTokenStatus" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/account.{format}/apiTokenStatus'
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('api_key' in params):
            headerParams['api_key'] = params['api_key']
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'ApiTokenStatus')
        return responseObject
        
        
    def getLoggedInUser(self, auth_token, **kwargs):
        """Returns the logged-in User

        Args:
            auth_token, str: The auth token of the logged-in user, obtained by calling /account.{format}/authenticate/{username} (described above) (required)
            
        Returns: User
        """

        allParams = ['auth_token']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method getLoggedInUser" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/account.{format}/user'
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('auth_token' in params):
            headerParams['auth_token'] = params['auth_token']
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'User')
        return responseObject
        
        
    


