#!/usr/bin/env python
"""
AccountAPI.py
Copyright 2011 Wordnik, Inc.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

NOTE: This class is auto generated by the swagger code generator program. Do not edit the class manually.
"""
import sys
import os

sys.path.append(os.path.dirname(os.path.abspath(__file__)) + '/../')
import model

class AccountAPI(object):

    def __init__(self, apiClient):
      self.apiClient = apiClient

    def authenticate(self, username, password, ):
        """Authenticates a User
        Args:
            username -- A confirmed Wordnik username
            password -- The user's password

        Return:
            AuthenticationToken -- an instance of AuthenticationToken"""

        # Parse inputs
        resourcePath = '/account.{format}/authenticate/{username}'
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        queryParams['password'] = self.apiClient.toPathValue(password)


        if username != None:
            resourcePath = resourcePath.replace('{username}', username)


        # Make the API Call
        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          None, headerParams)
        if not response:
            return None

        # Create output objects if the response has more than one object
        responseObject = self.apiClient.deserialize(response,
                                                    model.AuthenticationToken.AuthenticationToken)
        return responseObject


    def authenticatePost(self, username, postData, ):
        """Authenticates a user
        Args:
            username -- A confirmed Wordnik username
            postData -- The user's password

        Return:
            AuthenticationToken -- an instance of AuthenticationToken"""

        # Parse inputs
        resourcePath = '/account.{format}/authenticate/{username}'
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'POST'

        queryParams = {}
        headerParams = {}


        if username != None:
            resourcePath = resourcePath.replace('{username}', username)


        # Make the API Call
        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)
        if not response:
            return None

        # Create output objects if the response has more than one object
        responseObject = self.apiClient.deserialize(response,
                                                    model.AuthenticationToken.AuthenticationToken)
        return responseObject


    def getWordListsForCurrentUser(self, api_key, auth_token, skip=None, limit=None, ):
        """Fetches WordList objects for the logged-in user.
        Args:
            api_key -- 
            auth_token -- auth_token of logged-in user
            skip -- Results to skip
            limit -- Maximum number of results to return

        Return:
            list<WordList> -- an instance of WordList"""

        # Parse inputs
        resourcePath = '/account.{format}/wordLists'
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        queryParams['skip'] = self.apiClient.toPathValue(skip)
        queryParams['limit'] = self.apiClient.toPathValue(limit)


        if api_key != None:
		    headerParams['api_key'] = self.apiClient.toPathValue(api_key)
        if auth_token != None:
		    headerParams['auth_token'] = self.apiClient.toPathValue(auth_token)

        # Make the API Call
        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          None, headerParams)
        if not response:
            return None


        responseObjects = []
        for responseObject in response:
          responseObjects.append(self.apiClient.deserialize(responseObject,
                                                         model.WordList.WordList))
        return responseObjects
    def getApiTokenStatus(self, api_key, ):
        """Returns usage statistics for the API account.
        Args:
            api_key -- 

        Return:
            ApiTokenStatus -- an instance of ApiTokenStatus"""

        # Parse inputs
        resourcePath = '/account.{format}/apiTokenStatus'
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}


        if api_key != None:
		    headerParams['api_key'] = self.apiClient.toPathValue(api_key)

        # Make the API Call
        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          None, headerParams)
        if not response:
            return None

        # Create output objects if the response has more than one object
        responseObject = self.apiClient.deserialize(response,
                                                    model.ApiTokenStatus.ApiTokenStatus)
        return responseObject


    def getLoggedInUser(self, api_key, auth_token, ):
        """Returns the logged-in User
        Requires a valid auth_token to be set.
        Args:
            api_key -- 
            auth_token -- The auth token of the logged-in user, obtained by calling /account.{format}/authenticate/{username} (described above)

        Return:
            User -- an instance of User"""

        # Parse inputs
        resourcePath = '/account.{format}/user'
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}


        if api_key != None:
		    headerParams['api_key'] = self.apiClient.toPathValue(api_key)
        if auth_token != None:
		    headerParams['auth_token'] = self.apiClient.toPathValue(auth_token)

        # Make the API Call
        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          None, headerParams)
        if not response:
            return None

        # Create output objects if the response has more than one object
        responseObject = self.apiClient.deserialize(response,
                                                    model.User.User)
        return responseObject


