#!/usr/bin/env python
"""
WordAPI.py
Copyright 2011 Wordnik, Inc.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

NOTE: This class is auto generated by the swagger code generator program. Do not edit the class manually.
"""
import sys
import os

sys.path.append(os.path.dirname(os.path.abspath(__file__)) + '/../')
import model

class WordAPI(object):

    def __init__(self, apiClient):
      self.apiClient = apiClient

    def getExamples(self, wordExamplesInput=None, ):
        """Returns examples for a word
        Args:
            wordExamplesInput -- 

        Return:
            ExampleSearchResults -- an instance of ExampleSearchResults"""

        # Parse inputs
        resourcePath = '/word.{format}/{word}/examples'
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if wordExamplesInput != None and wordExamplesInput.includeDuplicates != None:
            queryParams['includeDuplicates'] = self.apiClient.toPathValue(wordExamplesInput.includeDuplicates)

        if wordExamplesInput != None and wordExamplesInput.contentProvider != None:
            queryParams['contentProvider'] = self.apiClient.toPathValue(wordExamplesInput.contentProvider)

        if wordExamplesInput != None and wordExamplesInput.useCanonical != None:
            queryParams['useCanonical'] = self.apiClient.toPathValue(wordExamplesInput.useCanonical)

        if wordExamplesInput != None and wordExamplesInput.skip != None:
            queryParams['skip'] = self.apiClient.toPathValue(wordExamplesInput.skip)

        if wordExamplesInput != None and wordExamplesInput.limit != None:
            queryParams['limit'] = self.apiClient.toPathValue(wordExamplesInput.limit)


        if wordExamplesInput != None and wordExamplesInput.word != None:
            resourcePath = resourcePath.replace('{word}', wordExamplesInput.word)


        # Make the API Call
        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          None, headerParams)
        if not response:
            return None

        # Create output objects if the response has more than one object
        responseObject = self.apiClient.deserialize(response,
                                                    model.ExampleSearchResults.ExampleSearchResults)
        return responseObject


    def getWord(self, word, useCanonical=None, includeSuggestions=None, ):
        """Given a word as a string, returns the WordObject that represents it
        Args:
            word -- String value of WordObject to return
            useCanonical -- If true will try to return the correct word root ('cats' -> 'cat'). If false returns exactly what was requested.
                    Allowed values are - false,trueincludeSuggestions -- Return suggestions (for correct spelling, case variants, etc.)
                    Allowed values are - false,true
        Return:
            WordObject -- an instance of WordObject"""

        # Parse inputs
        resourcePath = '/word.{format}/{word}'
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        queryParams['useCanonical'] = self.apiClient.toPathValue(useCanonical)
        queryParams['includeSuggestions'] = self.apiClient.toPathValue(includeSuggestions)


        if word != None:
            resourcePath = resourcePath.replace('{word}', word)


        # Make the API Call
        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          None, headerParams)
        if not response:
            return None

        # Create output objects if the response has more than one object
        responseObject = self.apiClient.deserialize(response,
                                                    model.WordObject.WordObject)
        return responseObject


    def getDefinitions(self, wordDefinitionsInput=None, ):
        """Return definitions for a word
        Args:
            wordDefinitionsInput -- 

        Return:
            list<Definition> -- an instance of Definition"""

        # Parse inputs
        resourcePath = '/word.{format}/{word}/definitions'
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if wordDefinitionsInput != None and wordDefinitionsInput.limit != None:
            queryParams['limit'] = self.apiClient.toPathValue(wordDefinitionsInput.limit)

        if wordDefinitionsInput != None and wordDefinitionsInput.partOfSpeech != None:
            queryParams['partOfSpeech'] = self.apiClient.toPathValue(wordDefinitionsInput.partOfSpeech)

        if wordDefinitionsInput != None and wordDefinitionsInput.includeRelated != None:
            queryParams['includeRelated'] = self.apiClient.toPathValue(wordDefinitionsInput.includeRelated)

        if wordDefinitionsInput != None and wordDefinitionsInput.sourceDictionaries != None:
            queryParams['sourceDictionaries'] = self.apiClient.toPathValue(wordDefinitionsInput.sourceDictionaries)

        if wordDefinitionsInput != None and wordDefinitionsInput.useCanonical != None:
            queryParams['useCanonical'] = self.apiClient.toPathValue(wordDefinitionsInput.useCanonical)

        if wordDefinitionsInput != None and wordDefinitionsInput.includeTags != None:
            queryParams['includeTags'] = self.apiClient.toPathValue(wordDefinitionsInput.includeTags)


        if wordDefinitionsInput != None and wordDefinitionsInput.word != None:
            resourcePath = resourcePath.replace('{word}', wordDefinitionsInput.word)


        # Make the API Call
        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          None, headerParams)
        if not response:
            return None


        responseObjects = []
        for responseObject in response:
          responseObjects.append(self.apiClient.deserialize(responseObject,
                                                         model.Definition.Definition))
        return responseObjects
    def getTopExample(self, word, contentProvider=None, useCanonical=None, ):
        """Returns a top example for a word
        Args:
            word -- Word to fetch examples for
            contentProvider -- Return results from a specific ContentProvider
            useCanonical -- If true will try to return the correct word root ('cats' -> 'cat'). If false returns exactly what was requested.
                    Allowed values are - false,true
        Return:
            Example -- an instance of Example"""

        # Parse inputs
        resourcePath = '/word.{format}/{word}/topExample'
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        queryParams['contentProvider'] = self.apiClient.toPathValue(contentProvider)
        queryParams['useCanonical'] = self.apiClient.toPathValue(useCanonical)


        if word != None:
            resourcePath = resourcePath.replace('{word}', word)


        # Make the API Call
        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          None, headerParams)
        if not response:
            return None

        # Create output objects if the response has more than one object
        responseObject = self.apiClient.deserialize(response,
                                                    model.Example.Example)
        return responseObject


    def getTextPronunciations(self, wordPronunciationsInput=None, ):
        """Returns text pronunciations for a given word
        Args:
            wordPronunciationsInput -- 

        Return:
            list<TextPron> -- an instance of TextPron"""

        # Parse inputs
        resourcePath = '/word.{format}/{word}/pronunciations'
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if wordPronunciationsInput != None and wordPronunciationsInput.useCanonical != None:
            queryParams['useCanonical'] = self.apiClient.toPathValue(wordPronunciationsInput.useCanonical)

        if wordPronunciationsInput != None and wordPronunciationsInput.sourceDictionary != None:
            queryParams['sourceDictionary'] = self.apiClient.toPathValue(wordPronunciationsInput.sourceDictionary)

        if wordPronunciationsInput != None and wordPronunciationsInput.typeFormat != None:
            queryParams['typeFormat'] = self.apiClient.toPathValue(wordPronunciationsInput.typeFormat)

        if wordPronunciationsInput != None and wordPronunciationsInput.limit != None:
            queryParams['limit'] = self.apiClient.toPathValue(wordPronunciationsInput.limit)


        if wordPronunciationsInput != None and wordPronunciationsInput.word != None:
            resourcePath = resourcePath.replace('{word}', wordPronunciationsInput.word)


        # Make the API Call
        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          None, headerParams)
        if not response:
            return None


        responseObjects = []
        for responseObject in response:
          responseObjects.append(self.apiClient.deserialize(responseObject,
                                                         model.TextPron.TextPron))
        return responseObjects
    def getHyphenation(self, word, useCanonical=None, sourceDictionary=None, limit=None, ):
        """Returns syllable information for a word
        Args:
            word -- Word to get syllables for
            useCanonical -- If true will try to return a correct word root ('cats' -> 'cat'). If false returns exactly what was requested.
            sourceDictionary -- Get from a single dictionary. Valid options: ahd, century, wiktionary, webster, and wordnet.
            limit -- Maximum number of results to return

        Return:
            list<Syllable> -- an instance of Syllable"""

        # Parse inputs
        resourcePath = '/word.{format}/{word}/hyphenation'
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        queryParams['useCanonical'] = self.apiClient.toPathValue(useCanonical)
        queryParams['sourceDictionary'] = self.apiClient.toPathValue(sourceDictionary)
        queryParams['limit'] = self.apiClient.toPathValue(limit)


        if word != None:
            resourcePath = resourcePath.replace('{word}', word)


        # Make the API Call
        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          None, headerParams)
        if not response:
            return None


        responseObjects = []
        for responseObject in response:
          responseObjects.append(self.apiClient.deserialize(responseObject,
                                                         model.Syllable.Syllable))
        return responseObjects
    def getWordFrequency(self, word, useCanonical=None, startYear=None, endYear=None, ):
        """Returns word usage over time
        Args:
            word -- Word to return
            useCanonical -- If true will try to return the correct word root ('cats' -> 'cat'). If false returns exactly what was requested.
            startYear -- Starting Year
            endYear -- Ending Year

        Return:
            FrequencySummary -- an instance of FrequencySummary"""

        # Parse inputs
        resourcePath = '/word.{format}/{word}/frequency'
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        queryParams['useCanonical'] = self.apiClient.toPathValue(useCanonical)
        queryParams['startYear'] = self.apiClient.toPathValue(startYear)
        queryParams['endYear'] = self.apiClient.toPathValue(endYear)


        if word != None:
            resourcePath = resourcePath.replace('{word}', word)


        # Make the API Call
        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          None, headerParams)
        if not response:
            return None

        # Create output objects if the response has more than one object
        responseObject = self.apiClient.deserialize(response,
                                                    model.FrequencySummary.FrequencySummary)
        return responseObject


    def getPhrases(self, word, limit=None, wlmi=None, useCanonical=None, ):
        """Fetches bi-gram phrases for a word
        Args:
            word -- Word to fetch phrases for
            limit -- Maximum number of results to return
            wlmi -- Minimum WLMI for the phrase
            useCanonical -- If true will try to return the correct word root ('cats' -> 'cat'). If false returns exactly what was requested.
                    Allowed values are - false,true
        Return:
            list<Bigram> -- an instance of Bigram"""

        # Parse inputs
        resourcePath = '/word.{format}/{word}/phrases'
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        queryParams['limit'] = self.apiClient.toPathValue(limit)
        queryParams['wlmi'] = self.apiClient.toPathValue(wlmi)
        queryParams['useCanonical'] = self.apiClient.toPathValue(useCanonical)


        if word != None:
            resourcePath = resourcePath.replace('{word}', word)


        # Make the API Call
        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          None, headerParams)
        if not response:
            return None


        responseObjects = []
        for responseObject in response:
          responseObjects.append(self.apiClient.deserialize(responseObject,
                                                         model.Bigram.Bigram))
        return responseObjects
    def getRelated(self, wordRelatedInput=None, ):
        """Return related words (thesaurus data) for a word
        Args:
            wordRelatedInput -- 

        Return:
            list<Related> -- an instance of Related"""

        # Parse inputs
        resourcePath = '/word.{format}/{word}/relatedWords'
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if wordRelatedInput != None and wordRelatedInput.partOfSpeech != None:
            queryParams['partOfSpeech'] = self.apiClient.toPathValue(wordRelatedInput.partOfSpeech)

        if wordRelatedInput != None and wordRelatedInput.sourceDictionary != None:
            queryParams['sourceDictionary'] = self.apiClient.toPathValue(wordRelatedInput.sourceDictionary)

        if wordRelatedInput != None and wordRelatedInput.limit != None:
            queryParams['limit'] = self.apiClient.toPathValue(wordRelatedInput.limit)

        if wordRelatedInput != None and wordRelatedInput.useCanonical != None:
            queryParams['useCanonical'] = self.apiClient.toPathValue(wordRelatedInput.useCanonical)

        if wordRelatedInput != None and wordRelatedInput.type != None:
            queryParams['type'] = self.apiClient.toPathValue(wordRelatedInput.type)


        if wordRelatedInput != None and wordRelatedInput.word != None:
            resourcePath = resourcePath.replace('{word}', wordRelatedInput.word)


        # Make the API Call
        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          None, headerParams)
        if not response:
            return None


        responseObjects = []
        for responseObject in response:
          responseObjects.append(self.apiClient.deserialize(responseObject,
                                                         model.Related.Related))
        return responseObjects
    def getAudio(self, word, useCanonical=None, limit=None, ):
        """Fetches audio metadata for a word.
        The metadata includes a time-expiring fileUrl which allows reading the audio file directly from the API.  Currently only audio pronunciations from the American Heritage Dictionary in mp3 format are supported.
        Args:
            word -- Word to get audio for.
            useCanonical -- Use the canonical form of the word.
            limit -- Maximum number of results to return

        Return:
            list<AudioFile> -- an instance of AudioFile"""

        # Parse inputs
        resourcePath = '/word.{format}/{word}/audio'
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        queryParams['useCanonical'] = self.apiClient.toPathValue(useCanonical)
        queryParams['limit'] = self.apiClient.toPathValue(limit)


        if word != None:
            resourcePath = resourcePath.replace('{word}', word)


        # Make the API Call
        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          None, headerParams)
        if not response:
            return None


        responseObjects = []
        for responseObject in response:
          responseObjects.append(self.apiClient.deserialize(responseObject,
                                                         model.AudioFile.AudioFile))
        return responseObjects
