#!/usr/bin/env python
"""
WordsAPI.py
Copyright 2011 Wordnik, Inc.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

NOTE: This class is auto generated by the swagger code generator program. Do not edit the class manually.
"""
import sys
import os

sys.path.append(os.path.dirname(os.path.abspath(__file__)) + '/../')
import model

class WordsAPI(object):

    def __init__(self, apiClient):
      self.apiClient = apiClient

    def searchWords(self, wordsSearchInput=None, ):
        """Searches words.
        Args:
            wordsSearchInput -- 

        Return:
            list<WordFrequency> -- an instance of WordFrequency"""

        # Parse inputs
        resourcePath = '/words.{format}/search'
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if wordsSearchInput != None and wordsSearchInput.query != None:
            queryParams['query'] = self.apiClient.toPathValue(wordsSearchInput.query)

        if wordsSearchInput != None and wordsSearchInput.caseSensitive != None:
            queryParams['caseSensitive'] = self.apiClient.toPathValue(wordsSearchInput.caseSensitive)

        if wordsSearchInput != None and wordsSearchInput.includePartOfSpeech != None:
            queryParams['includePartOfSpeech'] = self.apiClient.toPathValue(wordsSearchInput.includePartOfSpeech)

        if wordsSearchInput != None and wordsSearchInput.excludePartOfSpeech != None:
            queryParams['excludePartOfSpeech'] = self.apiClient.toPathValue(wordsSearchInput.excludePartOfSpeech)

        if wordsSearchInput != None and wordsSearchInput.minCorpusCount != None:
            queryParams['minCorpusCount'] = self.apiClient.toPathValue(wordsSearchInput.minCorpusCount)

        if wordsSearchInput != None and wordsSearchInput.maxCorpusCount != None:
            queryParams['maxCorpusCount'] = self.apiClient.toPathValue(wordsSearchInput.maxCorpusCount)

        if wordsSearchInput != None and wordsSearchInput.minDictionaryCount != None:
            queryParams['minDictionaryCount'] = self.apiClient.toPathValue(wordsSearchInput.minDictionaryCount)

        if wordsSearchInput != None and wordsSearchInput.maxDictionaryCount != None:
            queryParams['maxDictionaryCount'] = self.apiClient.toPathValue(wordsSearchInput.maxDictionaryCount)

        if wordsSearchInput != None and wordsSearchInput.minLength != None:
            queryParams['minLength'] = self.apiClient.toPathValue(wordsSearchInput.minLength)

        if wordsSearchInput != None and wordsSearchInput.maxLength != None:
            queryParams['maxLength'] = self.apiClient.toPathValue(wordsSearchInput.maxLength)

        if wordsSearchInput != None and wordsSearchInput.skip != None:
            queryParams['skip'] = self.apiClient.toPathValue(wordsSearchInput.skip)

        if wordsSearchInput != None and wordsSearchInput.limit != None:
            queryParams['limit'] = self.apiClient.toPathValue(wordsSearchInput.limit)



        # Make the API Call
        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          None, headerParams)
        if not response:
            return None


        responseObjects = []
        for responseObject in response:
          responseObjects.append(self.apiClient.deserialize(responseObject,
                                                         model.WordFrequency.WordFrequency))
        return responseObjects
    def getWordOfTheDay(self, date=None, category=None, creator=None, ):
        """Returns a specific WordOfTheDay
        Args:
            date -- Fetches by date in yyyy-MM-dd
            category -- Filters response by category
            creator -- Filters response by username

        Return:
            WordOfTheDay -- an instance of WordOfTheDay"""

        # Parse inputs
        resourcePath = '/words.{format}/wordOfTheDay'
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        queryParams['date'] = self.apiClient.toPathValue(date)
        queryParams['category'] = self.apiClient.toPathValue(category)
        queryParams['creator'] = self.apiClient.toPathValue(creator)



        # Make the API Call
        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          None, headerParams)
        if not response:
            return None

        # Create output objects if the response has more than one object
        responseObject = self.apiClient.deserialize(response,
                                                    model.WordOfTheDay.WordOfTheDay)
        return responseObject


    def searchWordsNew(self, query, caseSensitive=None, includePartOfSpeech=None, excludePartOfSpeech=None, minCorpusCount=None, maxCorpusCount=None, minDictionaryCount=None, maxDictionaryCount=None, minLength=None, maxLength=None, skip=None, limit=None, ):
        """Searches words.
        Args:
            query -- Search query
            caseSensitive -- Search case sensitive
                    Allowed values are - true,falseincludePartOfSpeech -- Only include these comma-delimited parts of speech
                    Allowed values are - noun,adjective,verb,adverb,interjection,pronoun,preposition,abbreviation,affix,article,auxiliary-verb,conjunction,definite-article,family-name,given-name,idiom,imperative,noun-plural,noun-posessive,past-participle,phrasal-prefix,proper-noun,proper-noun-plural,proper-noun-posessive,suffix,verb-intransitive,verb-transitiveexcludePartOfSpeech -- Exclude these comma-delimited parts of speech
            minCorpusCount -- Minimum corpus frequency for terms
                    Allowed values are - range[0.0,Infinity]maxCorpusCount -- Maximum corpus frequency for terms
                    Allowed values are - range[0.0,Infinity]minDictionaryCount -- Minimum number of dictionary entries
                    Allowed values are - range[0.0,Infinity]maxDictionaryCount -- Maximum dictionary count
                    Allowed values are - range[0.0,Infinity]minLength -- Minimum word length
                    Allowed values are - range[0.0,1024.0]maxLength -- Maximum word length
                    Allowed values are - range[0.0,1024.0]skip -- Results to skip
                    Allowed values are - range[0.0,1000.0]limit -- Maximum number of results to return
                    Allowed values are - range[1.0,1000.0]
        Return:
            WordSearchResults -- an instance of WordSearchResults"""

        # Parse inputs
        resourcePath = '/words.{format}/search/{query}'
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        queryParams['caseSensitive'] = self.apiClient.toPathValue(caseSensitive)
        queryParams['includePartOfSpeech'] = self.apiClient.toPathValue(includePartOfSpeech)
        queryParams['excludePartOfSpeech'] = self.apiClient.toPathValue(excludePartOfSpeech)
        queryParams['minCorpusCount'] = self.apiClient.toPathValue(minCorpusCount)
        queryParams['maxCorpusCount'] = self.apiClient.toPathValue(maxCorpusCount)
        queryParams['minDictionaryCount'] = self.apiClient.toPathValue(minDictionaryCount)
        queryParams['maxDictionaryCount'] = self.apiClient.toPathValue(maxDictionaryCount)
        queryParams['minLength'] = self.apiClient.toPathValue(minLength)
        queryParams['maxLength'] = self.apiClient.toPathValue(maxLength)
        queryParams['skip'] = self.apiClient.toPathValue(skip)
        queryParams['limit'] = self.apiClient.toPathValue(limit)


        if query != None:
            resourcePath = resourcePath.replace('{query}', query)


        # Make the API Call
        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          None, headerParams)
        if not response:
            return None

        # Create output objects if the response has more than one object
        responseObject = self.apiClient.deserialize(response,
                                                    model.WordSearchResults.WordSearchResults)
        return responseObject


    def getRandomWords(self, wordsRandomWordsInput=None, ):
        """Returns an array of random WordObjects
        Args:
            wordsRandomWordsInput -- 

        Return:
            list<WordObject> -- an instance of WordObject"""

        # Parse inputs
        resourcePath = '/words.{format}/randomWords'
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if wordsRandomWordsInput != None and wordsRandomWordsInput.hasDictionaryDef != None:
            queryParams['hasDictionaryDef'] = self.apiClient.toPathValue(wordsRandomWordsInput.hasDictionaryDef)

        if wordsRandomWordsInput != None and wordsRandomWordsInput.includePartOfSpeech != None:
            queryParams['includePartOfSpeech'] = self.apiClient.toPathValue(wordsRandomWordsInput.includePartOfSpeech)

        if wordsRandomWordsInput != None and wordsRandomWordsInput.excludePartOfSpeech != None:
            queryParams['excludePartOfSpeech'] = self.apiClient.toPathValue(wordsRandomWordsInput.excludePartOfSpeech)

        if wordsRandomWordsInput != None and wordsRandomWordsInput.minCorpusCount != None:
            queryParams['minCorpusCount'] = self.apiClient.toPathValue(wordsRandomWordsInput.minCorpusCount)

        if wordsRandomWordsInput != None and wordsRandomWordsInput.maxCorpusCount != None:
            queryParams['maxCorpusCount'] = self.apiClient.toPathValue(wordsRandomWordsInput.maxCorpusCount)

        if wordsRandomWordsInput != None and wordsRandomWordsInput.minDictionaryCount != None:
            queryParams['minDictionaryCount'] = self.apiClient.toPathValue(wordsRandomWordsInput.minDictionaryCount)

        if wordsRandomWordsInput != None and wordsRandomWordsInput.maxDictionaryCount != None:
            queryParams['maxDictionaryCount'] = self.apiClient.toPathValue(wordsRandomWordsInput.maxDictionaryCount)

        if wordsRandomWordsInput != None and wordsRandomWordsInput.minLength != None:
            queryParams['minLength'] = self.apiClient.toPathValue(wordsRandomWordsInput.minLength)

        if wordsRandomWordsInput != None and wordsRandomWordsInput.maxLength != None:
            queryParams['maxLength'] = self.apiClient.toPathValue(wordsRandomWordsInput.maxLength)

        if wordsRandomWordsInput != None and wordsRandomWordsInput.sortBy != None:
            queryParams['sortBy'] = self.apiClient.toPathValue(wordsRandomWordsInput.sortBy)

        if wordsRandomWordsInput != None and wordsRandomWordsInput.sortOrder != None:
            queryParams['sortOrder'] = self.apiClient.toPathValue(wordsRandomWordsInput.sortOrder)

        if wordsRandomWordsInput != None and wordsRandomWordsInput.limit != None:
            queryParams['limit'] = self.apiClient.toPathValue(wordsRandomWordsInput.limit)



        # Make the API Call
        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          None, headerParams)
        if not response:
            return None


        responseObjects = []
        for responseObject in response:
          responseObjects.append(self.apiClient.deserialize(responseObject,
                                                         model.WordObject.WordObject))
        return responseObjects
    def getRandomWord(self, wordsRandomWordInput=None, ):
        """Returns a single random WordObject
        Args:
            wordsRandomWordInput -- 

        Return:
            WordObject -- an instance of WordObject"""

        # Parse inputs
        resourcePath = '/words.{format}/randomWord'
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if wordsRandomWordInput != None and wordsRandomWordInput.hasDictionaryDef != None:
            queryParams['hasDictionaryDef'] = self.apiClient.toPathValue(wordsRandomWordInput.hasDictionaryDef)

        if wordsRandomWordInput != None and wordsRandomWordInput.includePartOfSpeech != None:
            queryParams['includePartOfSpeech'] = self.apiClient.toPathValue(wordsRandomWordInput.includePartOfSpeech)

        if wordsRandomWordInput != None and wordsRandomWordInput.excludePartOfSpeech != None:
            queryParams['excludePartOfSpeech'] = self.apiClient.toPathValue(wordsRandomWordInput.excludePartOfSpeech)

        if wordsRandomWordInput != None and wordsRandomWordInput.minCorpusCount != None:
            queryParams['minCorpusCount'] = self.apiClient.toPathValue(wordsRandomWordInput.minCorpusCount)

        if wordsRandomWordInput != None and wordsRandomWordInput.maxCorpusCount != None:
            queryParams['maxCorpusCount'] = self.apiClient.toPathValue(wordsRandomWordInput.maxCorpusCount)

        if wordsRandomWordInput != None and wordsRandomWordInput.minDictionaryCount != None:
            queryParams['minDictionaryCount'] = self.apiClient.toPathValue(wordsRandomWordInput.minDictionaryCount)

        if wordsRandomWordInput != None and wordsRandomWordInput.maxDictionaryCount != None:
            queryParams['maxDictionaryCount'] = self.apiClient.toPathValue(wordsRandomWordInput.maxDictionaryCount)

        if wordsRandomWordInput != None and wordsRandomWordInput.minLength != None:
            queryParams['minLength'] = self.apiClient.toPathValue(wordsRandomWordInput.minLength)

        if wordsRandomWordInput != None and wordsRandomWordInput.maxLength != None:
            queryParams['maxLength'] = self.apiClient.toPathValue(wordsRandomWordInput.maxLength)



        # Make the API Call
        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          None, headerParams)
        if not response:
            return None

        # Create output objects if the response has more than one object
        responseObject = self.apiClient.deserialize(response,
                                                    model.WordObject.WordObject)
        return responseObject


