#!/usr/bin/env python

from setuptools import setup

with open('README.rst') as readme_file:
    long_description = readme_file.read()
    
setup(name='wordseek',
      version='1.0.0',
      description='Robot word search',
      license='MIT',
      long_description=long_description,
      maintainer='David Hacker',
      maintainer_email='dmhacker@yahoo.com',
      url='https://github.com/dmhacker/wordseek',
      packages=['wskit', 'wskit.bots'],
      package_data={'wskit': ['*.py']},
      entry_points={
        'console_scripts': [
            'wordseek = wskit.wordseek:run'
        ]
    },
)
