#!/usr/bin/env python

from setuptools import setup

def read(fname):
    with open(fname, 'r') as fr:
        return fr.read()
    
setup(
    description='Robot word search game',
    packages=['wskit','wskit.bots'],
    long_description=read('README.rst'),
    entry_points={'console_scripts':['wordseek = wskit.wordseek:run']},
    name='wordseek',
    license='MIT',
    author='David Hacker',
    author_email='dmhacker@yahoo.com',
    url='https://github.com/dmhacker/wordseek',
    package_data={'wskit':['*.py']},
    version='1.0.7',
)