#!/usr/bin/env/python
# wyckedsceptre_constants.py
"""
@package wyckedsceptre_constants
A list of constants used in the wyckedsceptre module.
These constants are derived from the Dungeons & Dragons handbook 1 from
the first edition.
This data may be converted to some sort of database format in the future.
@todo change ABIL_SCORE_ORDER to include all abilities.

project home: http://code.google.com/p/wyckedsceptre/
Last Changed Date: $LastChangedDate: 2010-10-26 22:37:34 -0500 (Tue, 26 Oct 2$
Revision         : $Rev: 36 $
"""

## The order of highest to lowest ability scores for each classes
ABIL_SCORE_ORDER = {'cleric': ['WIS'], # currently only Primaries
                    'dwarf': ['STR'],
                    'elf': ['STR', 'INT'],
                    'fighter': ['STR'],
                    'magicuser': ['INT'],
                    'halfling': ['STR', 'DEX'],
                    'thief': ['DEX']}

## Saving throw values for each class
BASE_SAVING_THROWS = {'cleric': {'DEATHRAY-POISON': 11, 'MAGICWANDS': 12,
                                'PARALYSIS-TURNSTONE': 14, 'DRAGONBREATH': 16,
                                'RODS-STAVES-SPELLS': 15},
                      'fighter': {'DEATHRAY-POISON': 12, 'MAGICWANDS': 13,
                                'PARALYSIS-TURNSTONE': 14, 'DRAGONBREATH': 15,
                                'RODS-STAVES-SPELLS': 16},
                      'thief': {'DEATHRAY-POISON': 13, 'MAGICWANDS': 14,
                                'PARALYSIS-TURNSTONE': 13, 'DRAGONBREATH': 16,
                                'RODS-STAVES-SPELLS': 15},
                      'dwarf': {'DEATHRAY-POISON': 8, 'MAGICWANDS': 9,
                                'PARALYSIS-TURNSTONE': 10, 'DRAGONBREATH': 13,
                                'RODS-STAVES-SPELLS': 12},
                      'elf': {'DEATHRAY-POISON': 12, 'MAGICWANDS': 13,
                                'PARALYSIS-TURNSTONE': 13, 'DRAGONBREATH': 15,
                                'RODS-STAVES-SPELLS': 15},
                      'halfling': {'DEATHRAY-POISON': 8, 'MAGICWANDS': 9,
                                'PARALYSIS-TURNSTONE': 10, 'DRAGONBREATH': 13,
                                'RODS-STAVES-SPELLS': 12},
                      'magicuser': {'DEATHRAY-POISON': 13, 'MAGICWANDS': 14,
                                'PARALYSIS-TURNSTONE': 13, 'DRAGONBREATH': 16,
                                'RODS-STAVES-SPELLS': 15}}

## Levels and their corresponding minimum XP levels
XP_LEVELS = {'cleric':
                        {2: 1500, 3: 3000, 4: 6000, 5: 12000, 6: 25000,
                        7: 50000, 8: 100000, 9: 200000, 10: 300000,
                        11: 400000, 12: 500000, 13: 600000, 14: 700000},
             'dwarf':
                        {2: 2200, 3: 4400, 4: 8800, 5: 17000, 6: 35000,
                        7: 70000, 8: 140000, 9: 270000, 10: 400000,
                        11: 530000, 12: 660000},
             'elf':
                        {2: 4000, 3: 8000, 4: 16000, 5: 32000, 6: 64000,
                        7: 120000, 8: 250000, 9: 400000, 10: 600000},
             'fighter':
                        {2: 2000, 3: 4000, 4: 8000, 5: 16000, 6: 32000,
                        7: 64000, 8: 120000, 9: 240000, 10: 360000,
                        11: 480000, 12: 600000, 13: 720000, 14: 840000},
             'magicuser':
                        {2: 2500, 3: 5000, 4: 10000, 5: 20000, 6: 40000,
                        7: 80000, 8: 150000, 9: 300000, 10: 450000,
                        11: 600000, 12: 750000, 13: 900000, 14: 105000},
             'halfling':
                        {2: 2000, 3: 4000, 4: 8000, 5: 16000, 6: 32000,
                        7: 64000, 8: 120000},
             'thief':
                        {2: 1200, 3: 2400, 4: 4800, 5: 9600, 6: 20000,
                        7: 40000, 8: 80000, 9: 160000, 10: 280000, 11: 400000,
                        12: 520000, 13: 640000, 14: 760000}}
