#!/usr/bin/env/python
"""
@package example
Example uses of wyckedsceptre module classes and functions

project home: http://code.google.com/p/wyckedsceptre/
Last Changed Date: $LastChangedDate:                                         $
Revision         : $Rev:     $
"""
import sys
import os

## Add the wyckedsceptre main directory to current Python path
## This enables the "from wyckedsceptre.wyckedsceptre_constants" syntax
PATH_TO_WS_MAIN = os.path.realpath(__file__)
(PATH_TO_WS_MAIN, _) = os.path.split(PATH_TO_WS_MAIN)
PATH_TO_WS_MAIN = os.path.join(PATH_TO_WS_MAIN, "..")
sys.path.append(PATH_TO_WS_MAIN)
from wyckedsceptre.wyckedsceptre import Attack, roll_new_character
from wyckedsceptre.wyckedsceptre import load_file, save_file


def main():
    """
    Test script to simulate a combat between 2 characters
    """
#    random.seed(23423)

    mace = Attack('mace', '1d6', 1)
    print mace.roll_damage()

    bob = roll_new_character('bob', 'magicuser')
    print str(bob)
    bob.attack = mace

    for _ in range(10):
        print bob.make_attack()

    save_file(bob, 'bob.pickle')
    bob2 = load_file('bob.pickle')
    print bob2

    # Encounter hit back & forth
    player = roll_new_character('Player', 'fighter')
    player.is_npc = False
    npc = roll_new_character('NPC', 'magicuser')
    num_rounds = 0

    while player.hit_points > 0 and npc.hit_points > 0:
        print player.name + ' attacks ' + npc.name
        [hit_roll, damage] = player.make_attack()
        if  hit_roll >= npc.get_ac():
            print player.name + ' attack on ' + npc.name + ' HIT (' + \
                str(hit_roll) + 'v' + str(npc.get_ac()) + ') & did ' + \
                str(damage) + ' damage'
            npc.take_damage(damage)
        else:
            print player.name + ' attack on ' + npc.name + ' MISSED (' + \
                str(hit_roll) + 'v' + str(npc.get_ac()) + ')'
        print npc
        num_rounds += 1
    print 'sample encounter took ' + str(num_rounds) + ' rounds'
    print 'main() end'
    return 0


if __name__ == '__main__':
    main()
