#!/usr/bin/python
# make_manifest.py
"""
@package make_manifest
Builds the MANIFEST file for use in building distributions
Normal sdist calls do not include the docs directory, this code corrects
that.

project home: http://code.google.com/p/wyckedsceptre/
Last Changed Date: $LastChangedDate:                                         $
Revision         : $Rev:  $
"""


def main():
    """
    Makes the MANIFEST file, including documentation
    """
    import fnmatch
    import os

    root_path = '.'
    pattern = '*'

    try:
        file_handler = open('MANIFEST', 'w')
        for root, _, files in os.walk(root_path):
            for filename in fnmatch.filter(files, pattern):
                filepath = os.path.join(root, filename)
                if filepath.find('svn') != -1:
                    continue
                else:
                    filepath = filepath[2:] + '\n'
                    file_handler.write(filepath)
    finally:
        file_handler.close()


if '__main__' == __name__:
    main()
