#!/usr/bin/env/python
"""
@package example
Example uses of wyckedsceptre module classes and functions

project home: http://code.google.com/p/wyckedsceptre/
$LastChangedDate:                                                          $
$Rev:     $
"""
import sys
import os
import random

## Add the wyckedsceptre main directory to current Python path
## This enables the "from wyckedsceptre.wyckedsceptre_constants" syntax
PATH_TO_WS_MAIN = os.path.realpath(__file__)
(PATH_TO_WS_MAIN, _) = os.path.split(PATH_TO_WS_MAIN)
PATH_TO_WS_MAIN = os.path.join(PATH_TO_WS_MAIN, "..")
sys.path.append(PATH_TO_WS_MAIN)
from wyckedsceptre.wyckedsceptre import Attack, roll_new_character, Die
from wyckedsceptre.wyckedsceptre import load_file, save_file


def main():
    """
    Example uses of Die, Attack, and Character objects
    """
    random.seed(555)

    # create a Die
    example_1d20_die = Die('1d20')
    example_2d8_die = Die('2d8')

    for _ in range(5):
        print 'rolling ' + str(example_1d20_die) + ': ' + \
            str(example_1d20_die.roll())
        print 'rolling ' + str(example_2d8_die) + ': ' + \
            str(example_2d8_die.roll())

    # create a 1d6 + 1 attack named mace
    mace = Attack('mace', '1d6', 1)
    print 'rolling damage for ' + str(mace) + ' : ' + str(mace.roll_damage())

    # create a randomly skilled character
    bob = roll_new_character('bob', 'magicuser')
    print bob

    # the default character does not have an attack assigned, so it must
    # be assigned
    bob.attack = mace

    # demonstrate some attack rolls
    for _ in range(5):
        print bob.make_attack()  # prints in the form [attack roll, damage]

    save_file(bob, 'bob.pickle')    # save off a character
    bob2 = load_file('bob.pickle')  # load that same character
    print bob2


if __name__ == '__main__':
    main()
