#!/usr/bin/env/python
# encounter_example.py
"""
@package encounter_example
Example uses of the Encounter class from wyckedsceptre
"""
import sys
import os
import random

## Add the wyckedsceptre main directory to current Python path
## This enables the "from wyckedsceptre.wyckedsceptre_constants" syntax
PATH_TO_WS_MAIN = os.path.realpath(__file__)
(PATH_TO_WS_MAIN, _) = os.path.split(PATH_TO_WS_MAIN)
PATH_TO_WS_MAIN = os.path.join(PATH_TO_WS_MAIN, "..")
sys.path.append(PATH_TO_WS_MAIN)
from wyckedsceptre.wyckedsceptre import Attack, roll_new_character, Encounter


def main():
    """
    Test script to simulate a combat with several characters
    """
    start_seed = 555
    random.seed(start_seed)

    # create some attacks
    mace = Attack('mace', '1d6', 0)
    sword = Attack('sword', '1d8', 0)
    dagger = Attack('dagger', '1d4', 0)

    # create some NPC characters
    orc1 = roll_new_character('Orc1', 'fighter')
    orc2 = roll_new_character('Orc2', 'fighter')
    orc3 = roll_new_character('Orc3', 'fighter')
    orc1.is_npc = True
    orc2.is_npc = True
    orc3.is_npc = True
    orc1.attack = mace
    orc2.attack = sword
    orc3.attack = dagger
    orc1.initiative_bonus = 0
    orc2.initiative_bonus = 1
    orc3.initiative_bonus = 2

    # create some Player characters
    player1 = roll_new_character('player1', 'magicuser')
    player2 = roll_new_character('player2', 'fighter')
    player3 = roll_new_character('player3', 'cleric')
    player4 = roll_new_character('player4', 'halfling')
    player1.attack = dagger
    player2.attack = sword
    player3.attack = mace
    player4.attack = dagger
    player1.initiative_bonus = -1
    player2.initiative_bonus = 0
    player3.initiative_bonus = 1
    player4.initiative_bonus = 2
    player1.is_npc = False
    player2.is_npc = False
    player3.is_npc = False
    player4.is_npc = False

    # create the empty encounter object
    basic_fight = Encounter()

    # add the characters to the encounter
    basic_fight.add_character(player1, 'players')
    basic_fight.add_character(player2, 'players')
    basic_fight.add_character(player3, 'players')
    basic_fight.add_character(player4, 'players')
    basic_fight.add_character(orc1, 'npcs')
    basic_fight.add_character(orc2, 'npcs')
    basic_fight.add_character(orc3, 'npcs')

    # start the encounter
    #if basic_fight.run_encounter():
    #    print '\nPlayers win'
    #else:
    #    print '\nNPCs win'

    try:
        file_handler = open('encounter_run.csv', 'w')
        file_handler.write('round_number,start_seed,outcome\n')
        for round_number in range(1, 10000):
            basic_fight.reset_all_health()
            outcome = basic_fight.run_encounter()
            file_handler.write(str(round_number) + ',' + str(start_seed) + ',' + str(int(outcome)) + '\n')
    finally:
        file_handler.close()

if __name__ == '__main__':
    main()
