"""La función print_lol imprime listas que pueden contener anidadas otras listas"""

import sys

def print_lol(lista, sangrado = False, profundidad = 0, salida = sys.stdout):
    """Recorre una lista imprimiendo sus elementos.
    Si hay listas anidadas también imprime sus elementos individualmente.
    El argumento 'sangrado' activa o desactiva el sangrado de las listas anidadas.
    El argumento 'profundidad' controla el nivel de sangrado con que se muestran los elementos
    El argumento 'salida' selecciona hacia dónde imprime los datos(Por defecto: stdout, que suele ser 'por pantalla')"""
    for elemento in lista:
        if isinstance(elemento, list):
            print_lol(elemento, sangrado, profundidad+1, salida)
        else:
            if sangrado:
                for nivel in range(profundidad):
                    print("\t", end='', file=salida)
            print(elemento, file=salida)
