from xlrd import open_workbook


def get_col_num(name):
    """Convert column names to column numbers.
    A -> 1, B -> 2, AA -> 27, AB -> 28, etc.
    """
    num = 0
    for i, char in list(enumerate(reversed(name))):
        num = num + ((ord(char) - 64) + (i * 25))
    return num


def get_data(filename, sheetname, startcol='A', startrow=1, keycol='A'):
    """Return rows data in dict format. Must select a column as key."""
    wb = open_workbook(filename)
    sheet = wb.sheet_by_name(sheetname)

    data = {}
    for row in range(startrow, sheet.nrows):
        items = {}
        for col in range(get_col_num(startcol)-1, sheet.ncols):
            value = sheet.cell(row, col).value
            name = sheet.cell(startrow, col).value
            items[name] = value
        name = sheet.cell(row, get_col_num(keycol)-1).value
        data[name] = items
    return data


def get_datalist(filename, sheetname, startcol='A', startrow=1):
    """Return rows data in ordered list format."""
    wb = open_workbook(filename)
    sheet = wb.sheet_by_name(sheetname)

    datalist = []
    for row in range(startrow, sheet.nrows):
        item = {}
        for col in range(get_col_num(startcol)-1, sheet.ncols):
            value = sheet.cell(row, col).value
            name = sheet.cell(startrow-1, col).value
            item[name] = value
        datalist.append(item)
    return datalist
