#!/usr/bin/env python
#coding:utf-8
# Author:  mozman --<mozman@gmx.at>
# Purpose: test_mini
# Created: 03.12.2010
# Copyright (C) 2010, Manfred Moitzi
# License: GPLv3

import sys
import os
import unittest
import filecmp

import xlwt3

def from_tests_dir(filename):
    return os.path.join(os.path.dirname(os.path.abspath(__file__)), filename)

EXAMPLE_XLS = 'unicode0.xls'

class TestUnicode0(unittest.TestCase):
    def create_example_xls(self):
        book = xlwt3.Workbook(encoding='cp1251')
        sheet = book.add_sheet('cp1251-demo')
        sheet.write(0, 0, '\xce\xeb\xff')
        book.save(EXAMPLE_XLS)

    def test_example_xls(self):
        self.create_example_xls()
        self.assertTrue(filecmp.cmp(from_tests_dir(EXAMPLE_XLS),
                                    from_tests_dir('output-0.7.2/'+EXAMPLE_XLS),
                                    shallow=False))

if __name__=='__main__':
    unittest.main()