#!/usr/bin/env python
#coding:utf-8
# Author:  mozman
# Purpose:
# Created: 05.12.2010
# Copyright (C) 2010, Manfred Moitzi
# License: GPLv3

import sys
import unittest

from xlwt3.UnicodeUtils import upack1, upack2

class TestUpack(unittest.TestCase):
    def test_upack1(self):
        result = b'\x1d\x00abcdefghijklmnopqrstuvwxyz\xd6\xc4\xdc'
        ustr = upack1("abcdefghijklmnopqrstuvwxyzÖÄÜ")
        self.assertEqual(ustr, result)

    def test_upack2(self):
        result = b'\x1d\x00\x00abcdefghijklmnopqrstuvwxyz\xd6\xc4\xdc'
        ustr = upack2("abcdefghijklmnopqrstuvwxyzÖÄÜ")
        self.assertEqual(ustr, result)

if __name__=='__main__':
    unittest.main()