import StringIO

try:
    import unittest
    unittest.case
except AttributeError:
    import unittest2 as unittest

from lxml import etree

from xmltrans.factories import XMLFactory
from xmltrans.handlers import IgnoreHandler
from xmltrans.handlers import CopyHandler


SAMPLE_XML = '<examples><example><a/><b><c/></b><d/></example><example><a/><b/><d/></example></examples>'


class TestBaseFactoryFunctions(unittest.TestCase):

    def setUp(self):
        self.input_tree = etree.parse(StringIO.StringIO(SAMPLE_XML))
        self.xml_factory = XMLFactory(self.input_tree)
    
    def tearDown(self):
        self.xml_factory.flush_handlers()
        
    def test_handler_registration(self):
        self.xml_factory.register_handler('a', IgnoreHandler)
        self.assertEqual(self.xml_factory.handlers.keys(), ['a'])
        self.assertIsInstance(self.xml_factory.handlers.values()[0], IgnoreHandler)

    def test_handler_flushing(self):
        self.xml_factory.register_handler('a', IgnoreHandler)
        self.xml_factory.flush_handlers()
        self.assertEqual(self.xml_factory.handlers, {})

    def test_base_handlers(self):
        OUTPUT_XML = '<examples><example><b/><d/></example><example><b/><d/></example></examples>'
        self.xml_factory.register_handler('examples', CopyHandler)
        self.xml_factory.register_handler('example', CopyHandler)
        self.xml_factory.register_handler('b', CopyHandler)
        self.xml_factory.register_handler('d', CopyHandler)
        self.xml_factory.register_handler('a', IgnoreHandler)
        self.xml_factory.register_handler('c', IgnoreHandler)
        output_tree = self.xml_factory.run()
        self.assertEqual(etree.tostring(output_tree.getroot()), OUTPUT_XML)


if __name__ == '__main__':
    unittest.main()