# This file is part of xrayutilities.
#
# xrayutilities is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, see <http://www.gnu.org/licenses/>.
#
# Copyright (C) 2009 Eugen Wintersberger <eugen.wintersberger@desy.de>
# Copyright (C) 2010 Dominik Kriegner <dominik.kriegner@gmail.com>

from .lattice import Atom

Ac = Atom("Ac", 89)
Ag = Atom("Ag", 47)
Al = Atom("Al", 13)
Ar = Atom("Ar", 18)
As = Atom("As", 33)
At = Atom("At", 85)
Au = Atom("Au", 79)
B = Atom("B", 5)
Ba = Atom("Ba", 56)
Be = Atom("Be", 4)
Bi = Atom("Bi", 83)
Br = Atom("Br", 35)
C = Atom("C", 6)
Ca = Atom("Ca", 20)
Cd = Atom("Cd", 48)
Ce = Atom("Ce", 58)
Cl = Atom("Cl", 17)
Co = Atom("Co", 27)
Cr = Atom("Cr", 24)
Cs = Atom("Cs", 55)
Cu = Atom("Cu", 29)
Dy = Atom("Dy", 66)
Er = Atom("Er", 68)
Eu = Atom("Eu", 63)
F = Atom("F", 9)
Fe = Atom("Fe", 26)
Fr = Atom("Fr", 87)
Ga = Atom("Ga", 31)
Gd = Atom("Gd", 64)
Ge = Atom("Ge", 32)
H = Atom("H", 1)
He = Atom("He", 2)
Hf = Atom("Hf", 72)
Hg = Atom("Hg", 80)
Ho = Atom("Ho", 67)
I = Atom("I", 53)
In = Atom("In", 49)
Ir = Atom("Ir", 77)
K = Atom("K", 19)
Kr = Atom("Kr", 36)
La = Atom("La", 57)
Li = Atom("Li", 3)
Lu = Atom("Lu", 71)
Mg = Atom("Mg", 12)
Mn = Atom("Mn", 25)
Mo = Atom("Mo", 42)
N = Atom("N", 7)
Na = Atom("Na", 11)
Nb = Atom("Nb", 41)
Nd = Atom("Nd", 60)
Ne = Atom("Ne", 10)
Ni = Atom("Ni", 28)
O = Atom("O", 8)
Os = Atom("Os", 76)
P = Atom("P", 15)
Pa = Atom("Pa", 91)
Pb = Atom("Pb", 82)
Pd = Atom("Pd", 46)
Pm = Atom("Pm", 61)
Po = Atom("Po", 84)
Pr = Atom("Pr", 59)
Pt = Atom("Pt", 78)
Ra = Atom("Ra", 88)
Rb = Atom("Rb", 37)
Re = Atom("Re", 75)
Rh = Atom("Rh", 45)
Rn = Atom("Rn", 86)
Ru = Atom("Ru", 44)
S = Atom("S", 16)
Sb = Atom("Sb", 51)
Sc = Atom("Sc", 21)
Se = Atom("Se", 34)
Si = Atom("Si", 14)
Sm = Atom("Sm", 62)
Sn = Atom("Sn", 50)
Sr = Atom("Sr", 38)
Ta = Atom("Ta", 73)
Tb = Atom("Tb", 65)
Tc = Atom("Tc", 43)
Te = Atom("Te", 52)
Th = Atom("Th", 90)
Ti = Atom("Ti", 22)
Tl = Atom("Tl", 81)
Tm = Atom("Tm", 69)
U = Atom("U", 92)
V = Atom("V", 23)
W = Atom("W", 74)
Xe = Atom("Xe", 54)
Y = Atom("Y", 39)
Yb = Atom("Yb", 70)
Zn = Atom("Zn", 30)
Zr = Atom("Zr", 40)
