import os
import unittest
import doctest 
from pprint import pprint
from interlude import interact
import lxml.etree as etree

optionflags = doctest.NORMALIZE_WHITESPACE | \
              doctest.ELLIPSIS | \
              doctest.REPORT_ONLY_FIRST_FAILURE

TESTFILES = [
    'parser.txt',
    '../../../README.rst',
]

DEMO_FORM_PATH = os.path.join(os.path.split(__file__)[0], 'demo_form.yaml')


def test_vocab():
    """Used by tests to determine package path
    """
    return ['a', 'b', 'c']


def fxml(xml):
    et = etree.fromstring(xml)
    return etree.tostring(et, pretty_print=True)


def pxml(xml):
    print fxml(xml)


def test_suite():
    return unittest.TestSuite([
        doctest.DocFileSuite(
            file, 
            optionflags=optionflags,
            globs={'interact': interact,
                   'pprint': pprint,
                   'pxml': pxml,
                   'demo_form_path': DEMO_FORM_PATH},
        ) for file in TESTFILES
    ])

if __name__ == '__main__':
    unittest.main(defaultTest='test_suite')                  #pragma NO COVERAGE