from setuptools import setup, find_packages
import os

version = '1.0'
longdesc = open(os.path.join(os.path.dirname(__file__), 'README.rst')).read()
longdesc += open(os.path.join(os.path.dirname(__file__), 'HISTORY.rst')).read()
longdesc += open(os.path.join(os.path.dirname(__file__), 'LICENSE.rst')).read()
shortdesc = 'Zope2/ Plone Integration with YAFOWIL'
tests_require = ['interlude']

setup(name='yafowil.zope2',
      version=version,
      description=shortdesc,
      long_description=longdesc,
      classifiers=[
            'Development Status :: 5 - Production/Stable',
            'Operating System :: OS Independent',
            'Programming Language :: Python',
            'Topic :: Software Development',
            'Topic :: Internet :: WWW/HTTP :: Dynamic Content',
            'Framework :: Zope2',
            'Framework :: Plone',
            'License :: OSI Approved :: BSD License',                        
      ],
      keywords='zope2 request response html input widgets',
      author='BlueDynamics Alliance',
      author_email='dev@bluedynamics.com',
      url=u'http://packages.python.org/yafowil.zope2',
      license='Simplified BSD',
      packages=find_packages('src'),
      package_dir={'': 'src'},
      namespace_packages=['yafowil'],
      include_package_data=True,
      zip_safe=True,
      install_requires=[
          'setuptools',
          'Zope2',
          'yafowil',
      ],
      entry_points="""
      [z3c.autoinclude.plugin]
      target = plone

      [yafowil.plugin]
      register = yafowil.zope2:register
      """,
)
