from clint.textui import colored

from helpers import update_yaml_if_user_accepts

PREPOSITION = {"add": "to",
               "remove": "from"}

VERB = {"add": ("added", "+", colored.green),
        "remove": ("removed", "-", colored.red)}


def extract_delta_element(elem_data, sign):
    delta_elem = elem_data[2][0][1]
    if type(delta_elem) == dict:
        return "{}: {}".format(delta_elem.keys()[0], delta_elem.values()[0])
    if type(delta_elem) == list:
        return "\n {} ".join([elem for elem in delta_elem]).format(sign)
    if type(delta_elem) == str:
        return "\n {} ".join([elem[1] for elem in elem_data[2]]).format(sign)


def make_individual_deltas_for_top_level_elements(elem_data):
    top_level_elements = ["{}: {}".format(elem[0], elem[1]) for elem in elem_data[2]]
    return [top_level_elements, ""]


def get_delta_elements_and_specifier(elem_data):
    if elem_data[1] != "":
        delta_element = extract_delta_element(elem_data, VERB[elem_data[0]][1])
        specifier = " {} '{}'".format(PREPOSITION[elem_data[0]], elem_data[1])
        return [[delta_element], specifier]
    return make_individual_deltas_for_top_level_elements(elem_data)


def build_delta_info_string(specifier, delta_element, verb):
    verb = VERB[verb]
    delta_info = "Element(s) were {}{}".format(verb[0], specifier)
    delta_info += verb[2]("\n {} {}".format(verb[1], delta_element))
    return delta_info


def process_added_or_removed_element(yaml_map, elem_data):
    delta_elements, specifier = get_delta_elements_and_specifier(elem_data)
    for element in delta_elements:
        delta_info = build_delta_info_string(specifier, element, elem_data[0])
        updated_yaml = update_yaml_if_user_accepts(delta_info, yaml_map, elem_data)
    return updated_yaml
