from setuptools import setup, find_packages


setup(
    name="yaml-upgrade-tool",
    version='0.1.0',
    description="A Python package to assist with upgrading yaml configuration files.",
    long_description=file('README.rst').read(),
    author="Jarrod C. Taylor",
    author_email="Jarrod@JarrodCTaylor.com",
    url="https://bitbucket.org/JarrodCTaylor/yaml-upgrade-tool",
    license='GPL',
    packages=find_packages(),
    zip_safe=False,
    include_package_data=True,
    classifiers=[
        'Environment :: Console',
        'Topic :: System :: Systems Administration',
        'Intended Audience :: Developers',
        'Intended Audience :: End Users/Desktop'
    ],
    tests_require=[
        'nose',
        'mock',
        'pyyaml',
        'dictdiffer',
        'clint'
    ],
    test_suite='nose.collector',
    entry_points={
        'console_scripts': [
            'upgrade-yaml = src.main:main'
        ]
    },
    install_requires=['pyyaml', 'dictdiffer', 'clint']
)
