import unittest
from textwrap import dedent

from src.change import process_changed_element as sut
from test.mixins.assertion_mixin import PrintsAndResultsAssertionMixin


class ChangeUnitTests(PrintsAndResultsAssertionMixin, unittest.TestCase):

    def test_accepting_the_change_of_a_top_level_key_value(self):
        yaml_map = {'thing1': 'Stuff'}
        elem_data = ('change', 'thing1', ('Stuff', 'New Stuff'))
        expected_result = {'thing1': 'New Stuff'}
        expected_prints = dedent("""
        ***************
        The value in 'thing1' changed
         - Stuff
         + New Stuff
        """)[1:-1]
        self.validate(sut, yaml_map, elem_data, expected_result, expected_prints, ["y"])

    def test_decline_the_change_of_a_top_level_key_value(self):
        yaml_map = {'thing1': 'Stuff'}
        elem_data = ('change', 'thing1', ('Stuff', 'New Stuff'))
        expected_result = {'thing1': 'Stuff'}
        expected_prints = dedent("""
        ***************
        The value in 'thing1' changed
         - Stuff
         + New Stuff
        """)[1:-1]
        self.validate(sut, yaml_map, elem_data, expected_result, expected_prints, ["n"])

    def test_accepting_the_change_of_a_nested_key_vale(self):
        yaml_map = {'thing1': {'thing2': {'stuff1': 'The stuff'}}}
        elem_data = ('change', 'thing1.thing2.stuff1', ('The stuff', 'The new stuff'))
        expected_result = {'thing1': {'thing2': {'stuff1': 'The new stuff'}}}
        expected_prints = dedent("""
        ***************
        The value in 'thing1.thing2.stuff1' changed
         - The stuff
         + The new stuff
        """)[1:-1]
        self.validate(sut, yaml_map, elem_data, expected_result, expected_prints, ["y"])

    def test_decline_the_change_of_a_nested_key_vale(self):
        yaml_map = {'thing1': {'thing2': {'stuff1': 'The stuff'}}}
        elem_data = ('change', 'thing1.thing2.stuff1', ('The stuff', 'The new stuff'))
        expected_result = {'thing1': {'thing2': {'stuff1': 'The stuff'}}}
        expected_prints = dedent("""
        ***************
        The value in 'thing1.thing2.stuff1' changed
         - The stuff
         + The new stuff
        """)[1:-1]
        self.validate(sut, yaml_map, elem_data, expected_result, expected_prints, ["n"])

    def test_accepting_the_change_of_an_item_in_list(self):
        yaml_map = {'things': ['one', 'two']}
        elem_data = ('change', ['things', 1], ('two', 'new two'))
        expected_result = {'things': ['one', 'new two']}
        expected_prints = dedent("""
        ***************
        A value in 'things' changed
         - two
         + new two
        """)[1:-1]
        self.validate(sut, yaml_map, elem_data, expected_result, expected_prints, ["y"])

    def test_decline_the_change_of_an_item_in_list(self):
        yaml_map = {'things': ['one', 'two']}
        elem_data = ('change', ['things', 1], ('two', 'new two'))
        expected_result = {'things': ['one', 'two']}
        expected_prints = dedent("""
        ***************
        A value in 'things' changed
         - two
         + new two
        """)[1:-1]
        self.validate(sut, yaml_map, elem_data, expected_result, expected_prints, ["n"])

    def test_accepting_the_change_of_a_nested_key_value(self):
        yaml_map = {'level1': {'level2': [{'thing1': 'The first thing'}]}}
        elem_data = ('change', ['level1', 'level2', 0, 'thing1'], ('The first thing', 'The new first thing'))
        expected_result = {'level1': {'level2': [{'thing1': 'The new first thing'}]}}
        expected_prints = dedent("""
        ***************
        A value in 'level1.level2.thing1' changed
         - The first thing
         + The new first thing
        """)[1:-1]
        self.validate(sut, yaml_map, elem_data, expected_result, expected_prints, ["y"])

    def test_decline_the_change_of_a_nested_key_value(self):
        yaml_map = {'level1': {'level2': [{'thing1': 'The first thing'}]}}
        elem_data = ('change', ['level1', 'level2', 0, 'thing1'], ('The first thing', 'The new first thing'))
        expected_result = {'level1': {'level2': [{'thing1': 'The first thing'}]}}
        expected_prints = dedent("""
        ***************
        A value in 'level1.level2.thing1' changed
         - The first thing
         + The new first thing
        """)[1:-1]
        self.validate(sut, yaml_map, elem_data, expected_result, expected_prints, ["n"])

    def test_accepting_the_change_of_a_nested_item(self):
        yaml_map = {'level1': {'level2': ['something/goes/here']}}
        elem_data = ('change', ['level1', 'level2', 0], ('something/goes/here', 'something/new/goes/here'))
        expected_result = {'level1': {'level2': ['something/new/goes/here']}}
        expected_prints = dedent("""
        ***************
        A value in 'level1.level2' changed
         - something/goes/here
         + something/new/goes/here
        """)[1:-1]
        self.validate(sut, yaml_map, elem_data, expected_result, expected_prints, ["y"])

    def test_decline_the_chage_of_a_nested_item(self):
        yaml_map = {'level1': {'level2': ['something/goes/here']}}
        elem_data = ('change', ['level1', 'level2', 0], ('something/goes/here', 'something/new/goes/here'))
        expected_result = {'level1': {'level2': ['something/goes/here']}}
        expected_prints = dedent("""
        ***************
        A value in 'level1.level2' changed
         - something/goes/here
         + something/new/goes/here
        """)[1:-1]
        self.validate(sut, yaml_map, elem_data, expected_result, expected_prints, ["n"])
