from clint.textui import colored

from helpers import update_yaml_if_user_accepts


def get_key_and_article(elem_data):
    if isinstance(elem_data[1], str):
        return elem_data[1], "The"
    return ".".join([elem for elem in elem_data[1] if isinstance(elem, str)]), "A"


def build_change_info_string(article, key_name, val_from, val_to):
    change_info = "{} value in '{}' changed".format(article, key_name)
    change_info += colored.red("\n - {}".format(val_from))
    change_info += colored.green("\n + {}".format(val_to))
    return change_info


def process_changed_element(yaml_map, elem_data):
    val_from = elem_data[2][0]
    val_to = elem_data[2][1]
    key_name, article = get_key_and_article(elem_data)
    change_info = build_change_info_string(article, key_name, val_from, val_to)
    return update_yaml_if_user_accepts(change_info, yaml_map, elem_data)
