from os.path import basename, sep, expanduser

import yaml
from dictdiffer import diff
from clint.textui import colored

from helpers import read_file_contents, write_to_file
from add_remove import process_added_or_removed_element
from change import process_changed_element


PROCESS_DIFF_TYPE = {"add": process_added_or_removed_element,
                     "change": process_changed_element,
                     "remove": process_added_or_removed_element}


def get_files_from_user():
    current_file_path = raw_input("Path to current yaml file => ")
    new_file_path = raw_input("Path to the new yaml file => ")
    return read_file_contents(current_file_path), read_file_contents(new_file_path), current_file_path


def interactively_generate_migrated_yaml_string():
    current_file_contents, new_file_contents, current_file_path = get_files_from_user()
    current_yaml, new_yaml = yaml.load(current_file_contents), yaml.load(new_file_contents)
    delta = diff(current_yaml, new_yaml)
    for element in delta:
        current_yaml = PROCESS_DIFF_TYPE[element[0]](current_yaml, element)
    return yaml.dump(current_yaml), current_file_path


def main():
    migrated_yaml_string, current_file_path = interactively_generate_migrated_yaml_string()
    out_file_name = sep.join([expanduser('~'), "Downloads", "updated_{}".format(basename(current_file_path))])
    write_to_file(out_file_name, migrated_yaml_string)
    print(colored.green("\n\n" + ("=" * 20)))
    print(colored.green("Migrated file successfully saved to: {}\n".format(out_file_name)))
