import unittest
import mock
import sys
from textwrap import dedent

import src.main as sut
from helpers import read_file_contents
from test.mixins.assertion_mixin import PrintsAndResultsAssertionMixin


class MainIntergrationTests(PrintsAndResultsAssertionMixin, unittest.TestCase):

    def test_big_nasty(self):
        input_responses = [
            "test/resources/contrived_current.yaml",
            "test/resources/contrived_new.yaml",
            "n", "y", "y", "y", "y", "n", "y", "n", "y", "n"]
        expected_result = read_file_contents("test/resources/contrived_migrated.yaml")
        expected_prints = dedent("""
        ***************
        The value in 'cluster_name' changed
         - My Cluster
         + Test Cluster


        ***************
        Element(s) were removed from 'some_dir_paths.group1'
         - /test/dir/path3/


        ***************
        A value in 'data_file_directories.the_dirs' changed
         - /usr/bin/data1/
         + /var/lib/data1/


        ***************
        A value in 'data_file_directories.the_dirs' changed
         - /usr/bin/data2/
         + /var/lib/data2/


        ***************
        The value in 'data_file_directories.meta_data' changed
         - lives in bin
         + lives in lib


        ***************
        Element(s) were added
         + new_thing: hello


        ***************
        Element(s) were added
         + rpc_server_type: sync


        ***************
        Element(s) were removed
         - uncommented_property: baz


        ***************
        Element(s) were removed
         - other_things1: {'other_things2': {'stuff1': 'The stuff1', 'stuff2': 'The stuff2'}}


        ***************
        Element(s) were removed
         - memtable_flush_queue_size: 4
        """)[1:-1]
        with mock.patch("__builtin__.raw_input", side_effect=input_responses):
            response = sut.interactively_generate_migrated_yaml_string()[0]
            output = sys.stdout.getvalue().strip()
            self.assertEqual(response, expected_result)
            self.assertEqual(output, expected_prints)
