import mock
import sys
import unittest


class PrintsAndResultsAssertionMixin(unittest.TestCase):

    def validate(self, sut_process, yaml_map, elem_data, expected_result, expected_prints, side_effect):
        with mock.patch("__builtin__.raw_input", side_effect=side_effect):
            result = sut_process(yaml_map, elem_data)
            output = sys.stdout.getvalue().strip()
            self.assertEqual(result, expected_result)
            self.assertEqual(output, expected_prints)
