from setuptools import find_packages, setup

from pip.req import parse_requirements


def get_requirements(filename):
    reqs = parse_requirements(filename)

    return [str(r.req) for r in reqs]


def get_install_requires():
    return get_requirements('requirements.txt')


def get_test_requires():
    return get_requirements('requirements_dev.txt')


setup_args = dict(
    name='yaml2json',
    version='1.0.0',
    description="Convert YAML files to JSON",
    url='https://github.com/bretttrotter-wf/yaml2json',
    license="GPLv3",
    packages=find_packages(),
    install_requires=get_install_requires(),
    include_package_data=True,
    entry_points={
        'console_scripts': [
            'yaml2json=yaml2json:main'
        ]
    },
)


if __name__ == '__main__':
    setup(**setup_args)
