
from setuptools import setup

from yanktv import __version__

setup(
    name='yanktv',
    version=__version__,
    description='Yank torrents for the latest episodes of your tv shows.',
    long_description=open('README.rst').read(),
    classifiers=[ # See: http://pypi.python.org/pypi?%3Aaction=list_classifiers
        'Development Status :: 4 - Beta',
        'Environment :: Console',
        'License :: OSI Approved :: MIT License',
        'Programming Language :: Python :: 2',
        'Programming Language :: Python :: 2.7',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.2',
        'Topic :: Communications :: File Sharing',
        'Topic :: Multimedia :: Video',
        'Topic :: Utilities',
    ],
    keywords='tv show torrent episodes',
    url='https://github.com/lmas/yanktv',
    author='A. Svensson',
    author_email='lmasvensson@gmail.com',
    license='MIT',
    packages=['yanktv'],
    install_requires=[
        'requests >= 2.4',
        'beautifulsoup4 >= 4.3',
        'pyxdg >= 0.25',
    ],
    scripts=['bin/yanktv'],
    include_package_data=True,
    zip_safe=False
)

