
import sqlite3

class SQLiteStorage():
    def __init__(self, file='~/.yanktv.db'):
        self.file = file
        self.con = sqlite3.connect(self.file)
        self.cur = self.con.cursor()
        self.cur.execute('CREATE TABLE IF NOT EXISTS episodes (title TEXT UNIQUE, url TEXT);')

    def close(self):
        self.con.close()

    def commit(self):
        self.con.commit()

    def insert(self, title, url):
        try:
            self.cur.execute('INSERT OR FAIL INTO episodes (title, url) VALUES(?, ?);', (title, url))
        except sqlite3.IntegrityError:
            return False
        return True

