from pay import Yollapay
import json
import os


def credit_preauth(options):
    Y = Yollapay()
    args = dict([d for d in dict(type='preauth',
                                 number=options.number,
                                 expires=options.expires,
                                 amount=options.amount,
                                 swipe=options.swipe).items() if d[1]])
    result = Y.credit(args, account=options.account)
    if options.json:
        print json.dumps(result.json)
    else:
        if result.approved:
            print """

+-----------------------------------------------+
|            \033[92mTransaction Approved!\033[0m              |
|                                               |
|        Card Number: xxxx-xxxx-xxxx-1234       |
|             Amount: \033[92m$10.99\033[0m                    |
|                                               |
|               View receipt at                 |
|        \033[91mhttps://yollapay.com/pay/jH1U23jP\033[0m      |
+-----------------------------------------------+

"""
        else:
            print "Not approved"

def config(options):
    config_file = os.path.join(os.getenv('HOME'), ".yollapay")
    if not os.path.exists(config_file):
        print """\033[92mWelcome to Yollapay!\033[0m"""
        name = raw_input("  Your name: ")
        email = raw_input(" Your email: ")
        with open('data.txt', 'w') as outfile:
            json.dump(dict(api_key="xxx", api_secret="xxx"), outfile)
        print """All set!
"""
    else:
        print "\033[92mY:\033[0m Configuration already set up."
        # replace it?

def batch(options):
    print """
First Transaction - Latest Transaction
# of transactions
\033[32mTotal:\033[39m $1,500.75
"""

def batch_all(options):
    pass

def search(options):
    print options

def gateway(options):
    print """
\033[1mGateways for <store>\033[0m

    \033[32mfirstdata\033[39m - Credit Card Processing
        GATEWAY_ID = xxxx
        PASSWORD = xxxxx
        KEY = xxxxxx
        SECRET = xxxxx
"""

def gateway_add(options):
    if options.gateway is None:
        print """\033[92mY:\033[0m Available gateways to install
    FirstData G4
        via `yollapay gateway:add firstdata {'gateway_id': .... }`
"""
    else:
        print "Details about gateway", options.gateway

def account_add(options):
    print """\033[92mY:\033[0m Creating account %s...""" % options.name[0]
    print """\033[92mY:\033[0m Account \033[1m%(name)s\033[0m was created.
    \033[93mTip:\033[0m Use `yollapay <command> --account %(name)s` to reference %(name)s.
""" % dict(name=options.name[0])

def account(options):
    pass

def account_update(options):
    pass
