
class YollapayResponse:
    """This object will be shared from
    the yollapay-py::Response object.
    """
    def __init__(self, arguments):
        self._arguments = arguments

    @property
    def json(self):
        return self._arguments

    @property
    def meta(self):
        """Do not assume self.meta==200 means the transaction was approved
        """
        return self._arguments.get('meta', 204)

    @property
    def approved(self):
        """If the request was successful.
        If successful then you can continue to check data.
        If not successful then there was an erorr in the request
        """
        return self._arguments.get('approved', False) is True

    def __nonzero__(self):
        return self.approved