import unittest
import os
import commands
import tornado.httpclient
import json
from tornado.testing import AsyncTestCase
import yollapay


class TestAsync(AsyncTestCase):
    def test_http_fetch(self):
        yp = yollapay.Yollapay()
        yp.credit(dict(type="purchase",
                       number="4111111111111111",
                       amount="10.00",
                       expires="12/15"),
                  account=os.getenv("YOLLAPAY_ACCOUNT"),
                  httpclient=tornado.httpclient.AsyncHTTPClient(),
                  callback=self.callback) 
        self.wait()

    def callback(self, response):
        self.assertIsInstance(response, yollapay.YollapayResponse)
        self.assertTrue(response.approved)
        self.assertTrue(True if response else False)
        self.stop()

class TestAsyncSwipe(AsyncTestCase):
    def test_http_fetch(self):
        yp = yollapay.Yollapay()
        yp.credit(dict(type="purchase",
                       swipe="%B4111111111111111^SMITH/JOHN                ^15024041234567891234?\n;4111111111111111=150224041234567891234?",
                       amount="10.00"),
                  httpclient=tornado.httpclient.AsyncHTTPClient(),
                  callback=self.callback) 
        self.wait()

    def callback(self, response):
        self.assertIsInstance(response, yollapay.YollapayResponse)
        self.assertTrue(response.approved)
        self.assertTrue(True if response else False)
        self.stop()

# class TestAPI(unittest.TestCase):
#     def test_create_account(self):
#         # create new account
#         status, output = commands.getstatusoutput('yollapay account:add my-test-account | grep created')
#         self.assertEqual(output, "Y: Account my-test-account was created.")

#         # Add a gateway
#         status, output = commands.getstatusoutput('yollapay gateway:add firstdata --account my-test-account')
#         d = json.loads(output)
#         self.assertEqual(d['result'], True)
#         self.assertEqual(d['meta'], 200)
#         self.assertDictEqual(d['gateways'], {"firstdata": {"active": True, "gateway_id": "xxx", "last_used": "never"}})


#     def test_preauth(self):
#         status, output = commands.getstatusoutput('yollapay credit:preauth -n 4111111111111111 -e 0512 -a 10 --json --account my-test-account')
#         d = json.loads(output)
#         self.assertEqual(d['approved'], True)

if __name__ == '__main__':
    unittest.main()
