import api
import json
import os

Y = "\033[92mY:\033[0m"
YR = "\033[91mY:\033[0m"
TIP = "\033[93mTip:\033[0m"

"""All the commands below are to be used by the 
Yollapay entry point via bash. Not to be called directly.
"""

# ---------------
# Account
# ---------------
def account(options):
    if not options.json:
        print Y, "Retrieving your accounts..."
    answer = api.account.get(options.account[0] if options.account else None)
    if options.json:
        print json.dumps(answer.json, sort_keys=True, indent=4, separators=(',', ': '))
    else:
        if answer['result']:
            if options.account:
                pass
            else:
                for account in answer['accounts']:
                    print Y, "Account: \033[1m%-25s\033[0m\t%s" % (account['account'], account['name'] or '<null>')
        else:
            print YR, "You have no accounts."
            print TIP, "Create accounts via `yollapay account:add <unique-id> --name <business name>`"

def account_add(options):
    if not options.json:
        print Y, "Creating account %s..." % (options.id[0])
    answer = api.account.add(options.id[0], options.name)
    if options.json:
        print json.dumps(answer.json, sort_keys=True, indent=4, separators=(',', ': '))
    else:
        if answer['result']:
            print Y, "Account \033[1m%(name)s\033[0m was created successfully." % dict(name=options.id[0])
            print TIP, "Use `yollapay <command> --account %(name)s` to reference \033[1m%(name)s\033[0m." % dict(name=options.id[0])
        else:
            print YR, "Account \033[1m%(name)s\033[0m was not created." % dict(name=options.id[0])
            print answer['reason']

def account_set(options):
    if not options.json:
        print Y, "Updating account %s..." % (options.account or os.getenv('YOLLAPAY_ACCOUNT'))

    answer = api.account.set(account=options.account,
                             field=options.field[0],
                             value=' '.join(options.value) if type(options.value) is list else options.value)
    if options.json:
        print json.dumps(answer.json, sort_keys=True, indent=4, separators=(',', ': '))
    else:
        if answer['result']:
            print Y, "Account updated successfully"
        else:
            print YR, answer['reason']

# ---------------
# Batching
# ---------------
def batch(options):
    pass

def batch_all(options):
    pass

# ---------------
# Config
# ---------------
def config(options):
    config_file = os.path.join(os.getenv('HOME'), ".yollapay")
    if not os.path.exists(config_file):
        print """\033[92mWelcome to Yollapay!\033[0m"""
        name = raw_input("  Your name: ")
        email = raw_input(" Your email: ")
        with open('data.txt', 'w') as outfile:
            json.dump(dict(api_key="xxx", api_secret="xxx"), outfile)
        print "All set!"
    else:
        print Y, "Configuration already set up."
        # replace it?

# ---------------
# Credit
# ---------------
def credit_preauth(options):
    kargs = dict([d for d in dict(number=options.number,
                                  expires=options.expires,
                                  amount=options.amount,
                                  zip=options.zip,
                                  cv=options.cv,
                                  swipe=options.swipe).items() if d[1]])
    if not options.json:
        print Y, "Processing transaction..."
    result = api.credit.preauth(account=options.account, **kargs)
    if options.json:
        print json.dumps(result.json, sort_keys=True, indent=4, separators=(',', ': '))
    else:
        if result.approved:
            print Y, "Transaction Approved!", "Your receipt: \033[94mhttps://yollapay.com/jH1U23jP\033[0m"
        else:
            print YR, "\033[91mDeclined\033[0m", result.reason, result.errror or ''

# ---------------
# Gateway
# ---------------
def gateway(options):
    """Return a list of gateways attached to this account
    """
    pass

def gateway_add(options):
    """Method to add a new gateway to Yollapay
    """
    if options.gateway is not None:
        if not options.json:
            print Y, "Adding %s gateway..." % options.gateway
        gateway = api.gateway.add(gateway=options.gateway,
                                  username=options.username,
                                  password=options.password,
                                  key=options.key,
                                  secret=options.secret)
        if options.json:
            print json.dumps(gateway.json, sort_keys=True, indent=4, separators=(',', ': '))
        else:
            pass
    else:
        """Show a list of gateways and their properties
        """
        pass


# ---------------
# Keys
# ---------------


# ---------------
# Searching
# ---------------
def search(options):
    print options

