import unittest
import os
import commands
import tornado.httpclient
import json
from tornado.testing import AsyncTestCase
import yollapay


class TestAsync(AsyncTestCase):
    def test_http_fetch(self):
        yollapay.credit.preauth(number="4111111111111111",
                                amount="10.00",
                                expires="12/15",
                                zip="12345",
                                account=os.getenv("YOLLAPAY_ACCOUNT"),
                                httpclient=tornado.httpclient.AsyncHTTPClient(),
                                callback=self.callback)
        self.wait()

    def callback(self, response):
        self.assertIsInstance(response, yollapay.YollapayResponse)
        self.assertTrue(response.approved)
        self.assertTrue(True if response else False)
        self.stop()


class TestAsyncSwipe(AsyncTestCase):
    def test_http_fetch(self):
        yollapay.credit.preauth(swipe="%B4111111111111111^TEST CARD/VI^15121015432112345678?\n;4111111111111111=15121015432112345678?\n",
                                amount="10.00",
                                zip="12345",
                                httpclient=tornado.httpclient.AsyncHTTPClient(),
                                callback=self.callback)
        self.wait()

    def callback(self, response):
        self.assertIsInstance(response, yollapay.YollapayResponse)
        self.assertTrue(response.approved)
        self.assertTrue(True if response else False)
        self.stop()

class test_api_signup(unittest.TestCase):
    def test(self):
        """Signup the CI account
        """
        status, output = commands.getstatusoutput("""python yollapay/__init__.py signup \
                                                     --name "CI Test" \
                                                     --email "ci@yollapay.com" \
                                                     --phone "3098254722" \
                                                     --json
                                                     """)
        self.assertEqual(status, 0)
        # credentials are returned includeing api_key and api_secret
        # into the congif file
        # ....


class test_api_account(unittest.TestCase):
    def test_add(self):
        """yollapay account:add ci-account1
        """
        status, output = commands.getstatusoutput('python yollapay/__init__.py account:add ci-account1')
        self.assertEqual(status, 0)
        self.assertTrue(output.find("was created successfully") > -1)

    def test_duplicate(self):
        """yollapay account:add ci-account1
        - Not allowed becauase duplicate
        """
        status, output = commands.getstatusoutput('python yollapay/__init__.py account:add ci-account1')
        self.assertEqual(status, 0)
        self.assertTrue(output.find("was not created") > -1)

    def test_add_json(self):
        """yollapay account:add ci-account2 --json
        """
        status, output = commands.getstatusoutput('python yollapay/__init__.py account:add ci-account2 --name "Example Customer" --json')
        self.assertEqual(status, 0)
        self.assertDictEqual(json.loads(output),
                             dict(reason="Account created successfully",
                                  result=True))

    def test_get_json(self):
        """yollapay account --json
        """
        status, output = commands.getstatusoutput('python yollapay/__init__.py account --json')
        self.assertEqual(status, 0)
        j = json.loads(output)
        self.assertEqual(j['result'], True)
        self.assertEqual(j['reason'], 'Success')
        print sorted([dict(zip(['account', 'name'], [a['account'], a['name']])) for a in j['accounts']], key=lambda a: a['account'])
        self.assertListEqual(sorted([dict(zip(['account', 'name'], [a['account'], a['name']])) for a in j['accounts']], key=lambda a: a['account']),
                             [{'account': u'ci-account1', 'name': None},
                              {'account': u'ci-account2', 'name': u'Example Customer'}])

    def test_foreign_account(self):
        """yollapay account --account test-location1 --json
        """
        status, output = commands.getstatusoutput('python yollapay/__init__.py account test-location1 --json')
        self.assertEqual(status, 0)
        self.assertDictEqual(json.loads(output),
                             dict(result=False,
                                  reason="You are unauthorized to access this account."))


class test_api_gateway(unittest.TestCase):
    def test_add(self):
        """Adding a custom Monetra gateway using a different api end point.
        the endpoint, for testing is the same end point as Yollapay's Monetra
        """
        # Add a gateway - not json
        status, output = commands.getstatusoutput("""yollapay gateway:add firstdata-north \
                                                       --password xxxx \
                                                       --username xxxx""")
        self.assertTrue(output.find("successfully") > -1)
        self.assertTrue(output.find("Gateway credentials: pass") > -1)

        # Add a gateway - json
        status, output = commands.getstatusoutput("""yollapay gateway:add chase-paymentech-tampa \
                                                       --password xxxxx \
                                                       --username xxxxx \
                                                       --json""")
        print json.loads(output)


class test_api_credit(unittest.TestCase):
    def test_preauth(self):
        status, output = commands.getstatusoutput("""python yollapay/__init__.py credit:preauth \
                                                        -n 4111111111111111 \
                                                        -e 05/15 \
                                                        -a 10 \
                                                        --json \
                                                        --account my-test-account""")
        d = json.loads(output)
        self.assertEqual(d['approved'], True)


if __name__ == '__main__':
    unittest.main()
