import os, os.path, glob
import sys
import time
import subprocess
import distribute_setup
distribute_setup.use_setuptools()

from numpy.distutils.misc_util import appendpath
from numpy.distutils import log

DATA_FILES_HTML = glob.glob('yt/gui/reason/html/*.html')
DATA_FILES_JS   = glob.glob('yt/gui/reason/html/js/*.js')
DATA_FILES_PNG  = glob.glob('yt/gui/reason/html/images/*.png') \
                + glob.glob('yt/gui/reason/html/images/*.ico')
DATA_FILES_LL   = glob.glob('yt/gui/reason/html/leaflet/*.js') \
                + glob.glob('yt/gui/reason/html/leaflet/*.css')
DATA_FILES_LLI  = glob.glob('yt/gui/reason/html/leaflet/images/*.png')

import setuptools

VERSION = "2.2"

if os.path.exists('MANIFEST'): os.remove('MANIFEST')

def configuration(parent_package='',top_path=None):
    from numpy.distutils.misc_util import Configuration

    config = Configuration(None, parent_package, top_path)
    config.set_options(ignore_setup_xxx_py=True,
                       assume_default_configuration=True,
                       delegate_options_to_subpackages=True,
                       quiet=True)
    
    config.make_config_py()
    #config.make_svn_version_py()
    config.add_subpackage('yt','yt')
    config.add_scripts("scripts/*")

    return config

def setup_package():

    from numpy.distutils.core import setup

    setup(
        name = "yt",
        version = VERSION,
        description = "An analysis and visualization toolkit for Astrophysical "
                    + "simulations, focusing on Adaptive Mesh Refinement data "
                      "from Enzo, Orion, FLASH, and others.",
        classifiers = [ "Development Status :: 5 - Production/Stable",
                        "Environment :: Console",
                        "Intended Audience :: Science/Research",
                        "License :: OSI Approved :: GNU General Public License (GPL)",
                        "Operating System :: MacOS :: MacOS X",
                        "Operating System :: POSIX :: AIX",
                        "Operating System :: POSIX :: Linux",
                        "Programming Language :: C",
                        "Programming Language :: Python",
                        "Topic :: Scientific/Engineering :: Astronomy",
                        "Topic :: Scientific/Engineering :: Physics",
                        "Topic :: Scientific/Engineering :: Visualization", ],
        keywords='astronomy astrophysics visualization amr adaptivemeshrefinement',
        entry_points = { 'console_scripts' : [
                            'yt = yt.utilities.command_line:run_main',
                       ]},
        author="Matthew J. Turk",
        author_email="matthewturk@gmail.com",
        url = "http://yt-project.org/",
        license="GPL-3",
        configuration=configuration,
        zip_safe=False,
        data_files = [('yt/gui/reason/html/', DATA_FILES_HTML),
                      ('yt/gui/reason/html/js/', DATA_FILES_JS),
                      ('yt/gui/reason/html/images/', DATA_FILES_PNG),
                      ('yt/gui/reason/html/leaflet/', DATA_FILES_LL),
                      ('yt/gui/reason/html/leaflet/images', DATA_FILES_LLI)],
        )
    return

if __name__ == '__main__':
    setup_package()
