##############################################################################
#
# Copyright (c) 2005 Zope Foundation and Contributors.
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#
##############################################################################

"""
$Id: interfaces.py 81875 2007-11-16 03:52:32Z rogerineichen $
"""
__docformat__ = 'restructuredtext'

import zope.interface
import zope.schema
from zope.schema.interfaces import IVocabularyTokenized
from zope.session.interfaces import ISession
from zope.i18n.interfaces import INegotiator
from z3c.i18n import MessageFactory as _


language_policies = ['server', 'session', 'browser', 
    'browser --> session --> server', 'browser --> server', 
    'session --> browser --> server', 'session --> server']


class INegotiatorManager(zope.interface.Interface):
    """Local negotiator utility manager interface."""

    policy = zope.schema.Choice(
        title=_("Language lookup policy"),
        description=_("Defines how the language lookup is working."),
        values=language_policies,
        default='session --> browser --> server',
        required=True)

    serverLanguage = zope.schema.TextLine(
        title=_(u"Server language"),
        description=_(u"The language used for server policy."),
        default=u"en",
        required=True,
        )

    offeredLanguages = zope.schema.List(
        title=_(u"Offered languages"),
        description=_(u"A list of offered languages. Can be used for "
                      "let the user to select languages which are offered in "
                      "a skin."""),
        value_type = zope.schema.TextLine(title=_(u"A i18n language."),
            description=_(u"A i18n locale string.")),
        default=[],
        required=False,
        )


class IOfferedLanguages(zope.interface.Interface):

    def getOfferedLanguages():
        """A list of available (offered) languages."""

    def hasOfferedLanguages():
        """Retruns a boolean for available offered languages."""


class IOfferedLanguagesVocabulary(IVocabularyTokenized):
    """A vocabulary of available (offered) languages."""


class IAvailableTranslationDomainLanguagesVocabulary(IVocabularyTokenized):
    """Available translation domain languages.
    
    If you use this, take care on that you use the right translation domain.
    So you probably have to implement your own vocabulary for your ``correct``
    translation domain.
    """
