import os
from setuptools import setup, find_packages
import zenpad

setup(
    name     = 'zenpad',
    version  = zenpad.VERSION,
    author   = 'Imbolc',
    author_email = 'imbolc@imbolc.name',
    description = 'Tree-structured notepad',
    long_description = open(os.path.join(
        os.path.dirname(__file__), 'README.rst')).read(),
    zip_safe   = False,
    packages = find_packages(),
    include_package_data = True,
    url = 'http://zenpad.ru/',    
    entry_points = {
        'gui_scripts': [
            'zenpad = zenpad.zenpad:main',
        ]
    },
    classifiers = [
        "Programming Language :: Python",
        "License :: OSI Approved :: MIT License",
        "Development Status :: 4 - Beta",
        "Environment :: X11 Applications :: Qt",
        "Intended Audience :: End Users/Desktop",
        "Natural Language :: Russian",
        "Topic :: Text Editors",
    ],
)
