#!/usr/bin/env python
from setuptools import setup, find_packages
from distutils.command.install import INSTALL_SCHEMES

#pkgs = find_packages(where='.', exclude=['*svn*'])
pkgs = ['zflow', 'zflow.test']

for scheme in INSTALL_SCHEMES.values():
    scheme['data'] = scheme['purelib']

setup(
    name="zflow",
    version="0.01",
    description="Flow-based Programming Library for Python",
    long_description="Flow-based Programming Library using Python generators, "
        "loosely based on J.P. Morrison's book of the same name.",
    classifiers=[
        "Development Status :: 3 - Alpha",
        "Intended Audience :: Developers",
        "Programming Language :: Python",
        "Operating System :: OS Independent",
        "License :: OSI Approved :: GNU Library or Lesser General Public License (LGPL)"
    ],
    author="Jeremy Lowery",
    author_email="jlowery@zertis.net",
    url="http://www.thensys.com",
    install_requires = ["networkx"],
    zip_safe=False,
    data_files=[('.', ['README.txt'])],
    download_url="http://www.thensys.com/bin/",
    license="LGPL",
    platform="OS Independant",
    packages = pkgs)
