""" Module lookup and registry system. """
import sys
import threading as _threading

class modbase(object):
    _lock = _threading.Lock()

    def __init__(self, search_list=[], reg_list=[]):
        self.search_list = list(search_list)
        self.reg_list = reg_list

    def add(self, path):
        self.search_list.append(path)

    def reg(self, o, name=None):
        if name is None:
            name = o.__name__
        
        self.reg_list['name'] = o

    def __call__(self, search):
        """ Find the given module string in our currently database. """
        if ':' in search:
            target = search.split(':', 2)[1]
            search = search.split(':', 2)[0]
        else:
            target = ''
        if '.' in search:
            from_list = search.split(".")[-1]
        else:
            from_list = []

        # Is it in our reg_list?
        if search in self.reg_list:
            o = self.reg_list[search]
            if target:
                try:
                    return getattr(o, target)
                except AttributeError:
                    pass
            else:
                return o

        # do the sys.path hack
        g, l = {}, {}
        self._lock.acquire()
        try:
            for sl in self.search_list:
                sys.path.insert(0, sl)
            try:
                M = __import__(search, g, l, from_list)
                if target:
                    return getattr(M, target)
                else:
                    return M
            finally:
                for sl in self.search_list:
                    del sys.path[0]
        finally:
            self._lock.release()
