#!/usr/bin/env python
from setuptools import setup
from distutils.command.install import INSTALL_SCHEMES

pkgs = ['zflow', 'zflow.test']

for scheme in INSTALL_SCHEMES.values():
    scheme['data'] = scheme['purelib']

setup(
    name="zflow",
    version="0.02",
    author="Jeremy Lowery",
    author_email="jeremy@bitrel.com",
    url="https://bitbucket.org/jslowery/zflow",
    license="MIT",
    description="Flow-based Programming Library for Python",
    long_description="Flow-based Programming Library using Python generators, "
        "loosely based on J.P. Morrison's book of the same name.",
    classifiers=[
        "Development Status :: 4 - Beta",
        "Intended Audience :: Developers",
        "Programming Language :: Python",
        "Operating System :: OS Independent",
        "License :: OSI Approved :: MIT License"
    ],
    zip_safe=False,
    data_files=[('.', ['README.txt'])],
    download_url="https://bitbucket.org/jslowery/zflow/downloads/zflow-0.02.tar.gz",
    provides=["zflow"],
    packages = pkgs)
