import sys
import os
sys.path.append(os.path.split(os.path.realpath(__file__))[0])

import zipkinQuery.ZipkinQuery

from thrift import Thrift
from thrift.transport import TSocket
from thrift.transport import TTransport
from thrift.protocol import TBinaryProtocol

class Api(object):
    """docstring for Api"""
    def __init__(self, host='10.202.76.52', port=8411):

        self.host = host
        self.port = port
        # Make socket
        socket = TSocket.TSocket(host, port)

        # Buffering is critical. Raw sockets are very slow
        self.transport = TTransport.TFramedTransport(socket)

        # Wrap in a protocol
        protocol = TBinaryProtocol.TBinaryProtocol(trans=self.transport, strictRead=False, strictWrite=False)

        # Create a client to use the protocol encoder
        self.client = zipkinQuery.ZipkinQuery.Client(protocol)

        # Connect!
        self.transport.open()


    def conncet(self):
        return self.client

    def close(self):
        self.transport.close()
        pass


