#
# Autogenerated by Thrift Compiler (0.9.1)
#
# DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
#
#  options string: py
#

from thrift.Thrift import TType, TMessageType, TException, TApplicationException
from ttypes import *
from thrift.Thrift import TProcessor
from thrift.transport import TTransport
from thrift.protocol import TBinaryProtocol, TProtocol
try:
  from thrift.protocol import fastbinary
except:
  fastbinary = None


class Iface:
  def getTraceIds(self, request):
    """
    Parameters:
     - request
    """
    pass

  def getTraceIdsBySpanName(self, service_name, span_name, end_ts, limit, order, start_ts):
    """
    Fetch trace ids by service and span name.
    Gets "limit" number of entries from before the "end_ts".

    Span name is optional.
    Timestamps are in microseconds.

    Parameters:
     - service_name
     - span_name
     - end_ts
     - limit
     - order
     - start_ts
    """
    pass

  def getTraceIdsByServiceName(self, service_name, end_ts, limit, order, start_ts):
    """
    Fetch trace ids by service name.
    Gets "limit" number of entries from before the "end_ts".

    Timestamps are in microseconds.

    Parameters:
     - service_name
     - end_ts
     - limit
     - order
     - start_ts
    """
    pass

  def getTraceIdsByAnnotation(self, service_name, annotation, value, end_ts, limit, order, start_ts):
    """
    Fetch trace ids with a particular annotation.
    Gets "limit" number of entries from before the "end_ts".

    When requesting based on time based annotations only pass in the first parameter, "annotation" and leave out
    the second "value". If looking for a key-value binary annotation provide both, "annotation" is then the
    key in the key-value.

    Timestamps are in microseconds.

    Parameters:
     - service_name
     - annotation
     - value
     - end_ts
     - limit
     - order
     - start_ts
    """
    pass

  def tracesExist(self, trace_ids):
    """
    Get the traces that are in the database from the given list of trace ids.

    Parameters:
     - trace_ids
    """
    pass

  def getTracesByIds(self, trace_ids, adjust):
    """
    Get the full traces associated with the given trace ids.

    Second argument is a list of methods of adjusting the trace
    data before returning it. Can be empty.

    Parameters:
     - trace_ids
     - adjust
    """
    pass

  def getTraceTimelinesByIds(self, trace_ids, adjust):
    """
    Get the trace timelines associated with the given trace ids.
    This is a convenience method for users that just want to know
    the annotations and the (assumed) order they happened in.

    Second argument is a list of methods of adjusting the trace
    data before returning it. Can be empty.

    Note that if one of the trace ids does not have any data associated with it, it will not be
    represented in the output list.

    Parameters:
     - trace_ids
     - adjust
    """
    pass

  def getTraceSummariesByIds(self, trace_ids, adjust):
    """
    Fetch trace summaries for the given trace ids.

    Second argument is a list of methods of adjusting the trace
    data before returning it. Can be empty.

    Note that if one of the trace ids does not have any data associated with it, it will not be
    represented in the output list.

    Parameters:
     - trace_ids
     - adjust
    """
    pass

  def getTraceCombosByIds(self, trace_ids, adjust):
    """
    Not content with just one of traces, summaries or timelines? Want it all? This is the method for you.

    Parameters:
     - trace_ids
     - adjust
    """
    pass

  def getServiceNames(self):
    """
    Fetch all the service names we have seen from now all the way back to the set ttl.
    """
    pass

  def getSpanNames(self, service_name):
    """
    Get all the seen span names for a particular service, from now back until the set ttl.

    Parameters:
     - service_name
    """
    pass

  def setTraceTimeToLive(self, trace_id, ttl_seconds):
    """
    Change the TTL of a trace. If we find an interesting trace we want to keep around for further
    investigation.

    Parameters:
     - trace_id
     - ttl_seconds
    """
    pass

  def getTraceTimeToLive(self, trace_id):
    """
    Get the TTL in seconds of a specific trace.

    Parameters:
     - trace_id
    """
    pass

  def getDataTimeToLive(self):
    """
    Get the data ttl. This is the number of seconds we keep the data around before deleting it.
    """
    pass

  def getDependencies(self, start_time, end_time):
    """
    Get an aggregate representation of all services paired with every service they call in to.
    This includes information on call counts and mean/stdDev/etc of call durations.  The two arguments
    specify epoch time in microseconds. The end time is optional and defaults to one day after the
    start time.

    Parameters:
     - start_time
     - end_time
    """
    pass

  def getTopAnnotations(self, service_name):
    """
    Parameters:
     - service_name
    """
    pass

  def getTopKeyValueAnnotations(self, service_name):
    """
    Parameters:
     - service_name
    """
    pass

  def getSpanDurations(self, time_stamp, service_name, rpc_name):
    """
    Given a time stamp, server service name, and rpc name, fetch all of the client services calling in paired
    with the lists of every span duration (list<i64>) from the server to client. The lists of span durations
    include information on call counts and mean/stdDev/etc of call durations.

    The three arguments specify epoch time in microseconds, server side service name and rpc name. The return maps
    contains the key - client_service_name and value - list<span_durations>.

    Parameters:
     - time_stamp
     - service_name
     - rpc_name
    """
    pass

  def getServiceNamesToTraceIds(self, time_stamp, service_name, rpc_name):
    """
    Given a time stamp, server service name, and rpc name, fetch all of the client services calling in paired
    with the lists of every trace Ids (list<i64>) from the server to client.

    The three arguments specify epoch time in microseconds, server side service name and rpc name. The return maps
    contains the key - client_service_name and value - list<trace_id>.

    Parameters:
     - time_stamp
     - service_name
     - rpc_name
    """
    pass


class Client(Iface):
  def __init__(self, iprot, oprot=None):
    self._iprot = self._oprot = iprot
    if oprot is not None:
      self._oprot = oprot
    self._seqid = 0

  def getTraceIds(self, request):
    """
    Parameters:
     - request
    """
    self.send_getTraceIds(request)
    return self.recv_getTraceIds()

  def send_getTraceIds(self, request):
    self._oprot.writeMessageBegin('getTraceIds', TMessageType.CALL, self._seqid)
    args = getTraceIds_args()
    args.request = request
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getTraceIds(self):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getTraceIds_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.qe is not None:
      raise result.qe
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getTraceIds failed: unknown result");

  def getTraceIdsBySpanName(self, service_name, span_name, end_ts, limit, order, start_ts):
    """
    Fetch trace ids by service and span name.
    Gets "limit" number of entries from before the "end_ts".

    Span name is optional.
    Timestamps are in microseconds.

    Parameters:
     - service_name
     - span_name
     - end_ts
     - limit
     - order
     - start_ts
    """
    self.send_getTraceIdsBySpanName(service_name, span_name, end_ts, limit, order, start_ts)
    return self.recv_getTraceIdsBySpanName()

  def send_getTraceIdsBySpanName(self, service_name, span_name, end_ts, limit, order, start_ts):
    self._oprot.writeMessageBegin('getTraceIdsBySpanName', TMessageType.CALL, self._seqid)
    args = getTraceIdsBySpanName_args()
    args.service_name = service_name
    args.span_name = span_name
    args.end_ts = end_ts
    args.limit = limit
    args.order = order
    args.start_ts = start_ts
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getTraceIdsBySpanName(self):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getTraceIdsBySpanName_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.qe is not None:
      raise result.qe
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getTraceIdsBySpanName failed: unknown result");

  def getTraceIdsByServiceName(self, service_name, end_ts, limit, order, start_ts):
    """
    Fetch trace ids by service name.
    Gets "limit" number of entries from before the "end_ts".

    Timestamps are in microseconds.

    Parameters:
     - service_name
     - end_ts
     - limit
     - order
     - start_ts
    """
    self.send_getTraceIdsByServiceName(service_name, end_ts, limit, order, start_ts)
    return self.recv_getTraceIdsByServiceName()

  def send_getTraceIdsByServiceName(self, service_name, end_ts, limit, order, start_ts):
    self._oprot.writeMessageBegin('getTraceIdsByServiceName', TMessageType.CALL, self._seqid)
    args = getTraceIdsByServiceName_args()
    args.service_name = service_name
    args.end_ts = end_ts
    args.limit = limit
    args.order = order
    args.start_ts = start_ts
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getTraceIdsByServiceName(self):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getTraceIdsByServiceName_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.qe is not None:
      raise result.qe
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getTraceIdsByServiceName failed: unknown result");

  def getTraceIdsByAnnotation(self, service_name, annotation, value, end_ts, limit, order, start_ts):
    """
    Fetch trace ids with a particular annotation.
    Gets "limit" number of entries from before the "end_ts".

    When requesting based on time based annotations only pass in the first parameter, "annotation" and leave out
    the second "value". If looking for a key-value binary annotation provide both, "annotation" is then the
    key in the key-value.

    Timestamps are in microseconds.

    Parameters:
     - service_name
     - annotation
     - value
     - end_ts
     - limit
     - order
     - start_ts
    """
    self.send_getTraceIdsByAnnotation(service_name, annotation, value, end_ts, limit, order, start_ts)
    return self.recv_getTraceIdsByAnnotation()

  def send_getTraceIdsByAnnotation(self, service_name, annotation, value, end_ts, limit, order, start_ts):
    self._oprot.writeMessageBegin('getTraceIdsByAnnotation', TMessageType.CALL, self._seqid)
    args = getTraceIdsByAnnotation_args()
    args.service_name = service_name
    args.annotation = annotation
    args.value = value
    args.end_ts = end_ts
    args.limit = limit
    args.order = order
    args.start_ts = start_ts
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getTraceIdsByAnnotation(self):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getTraceIdsByAnnotation_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.qe is not None:
      raise result.qe
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getTraceIdsByAnnotation failed: unknown result");

  def tracesExist(self, trace_ids):
    """
    Get the traces that are in the database from the given list of trace ids.

    Parameters:
     - trace_ids
    """
    self.send_tracesExist(trace_ids)
    return self.recv_tracesExist()

  def send_tracesExist(self, trace_ids):
    self._oprot.writeMessageBegin('tracesExist', TMessageType.CALL, self._seqid)
    args = tracesExist_args()
    args.trace_ids = trace_ids
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_tracesExist(self):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = tracesExist_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.qe is not None:
      raise result.qe
    raise TApplicationException(TApplicationException.MISSING_RESULT, "tracesExist failed: unknown result");

  def getTracesByIds(self, trace_ids, adjust):
    """
    Get the full traces associated with the given trace ids.

    Second argument is a list of methods of adjusting the trace
    data before returning it. Can be empty.

    Parameters:
     - trace_ids
     - adjust
    """
    self.send_getTracesByIds(trace_ids, adjust)
    return self.recv_getTracesByIds()

  def send_getTracesByIds(self, trace_ids, adjust):
    self._oprot.writeMessageBegin('getTracesByIds', TMessageType.CALL, self._seqid)
    args = getTracesByIds_args()
    args.trace_ids = trace_ids
    args.adjust = adjust
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getTracesByIds(self):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getTracesByIds_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.qe is not None:
      raise result.qe
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getTracesByIds failed: unknown result");

  def getTraceTimelinesByIds(self, trace_ids, adjust):
    """
    Get the trace timelines associated with the given trace ids.
    This is a convenience method for users that just want to know
    the annotations and the (assumed) order they happened in.

    Second argument is a list of methods of adjusting the trace
    data before returning it. Can be empty.

    Note that if one of the trace ids does not have any data associated with it, it will not be
    represented in the output list.

    Parameters:
     - trace_ids
     - adjust
    """
    self.send_getTraceTimelinesByIds(trace_ids, adjust)
    return self.recv_getTraceTimelinesByIds()

  def send_getTraceTimelinesByIds(self, trace_ids, adjust):
    self._oprot.writeMessageBegin('getTraceTimelinesByIds', TMessageType.CALL, self._seqid)
    args = getTraceTimelinesByIds_args()
    args.trace_ids = trace_ids
    args.adjust = adjust
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getTraceTimelinesByIds(self):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getTraceTimelinesByIds_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.qe is not None:
      raise result.qe
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getTraceTimelinesByIds failed: unknown result");

  def getTraceSummariesByIds(self, trace_ids, adjust):
    """
    Fetch trace summaries for the given trace ids.

    Second argument is a list of methods of adjusting the trace
    data before returning it. Can be empty.

    Note that if one of the trace ids does not have any data associated with it, it will not be
    represented in the output list.

    Parameters:
     - trace_ids
     - adjust
    """
    self.send_getTraceSummariesByIds(trace_ids, adjust)
    return self.recv_getTraceSummariesByIds()

  def send_getTraceSummariesByIds(self, trace_ids, adjust):
    self._oprot.writeMessageBegin('getTraceSummariesByIds', TMessageType.CALL, self._seqid)
    args = getTraceSummariesByIds_args()
    args.trace_ids = trace_ids
    args.adjust = adjust
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getTraceSummariesByIds(self):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getTraceSummariesByIds_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.qe is not None:
      raise result.qe
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getTraceSummariesByIds failed: unknown result");

  def getTraceCombosByIds(self, trace_ids, adjust):
    """
    Not content with just one of traces, summaries or timelines? Want it all? This is the method for you.

    Parameters:
     - trace_ids
     - adjust
    """
    self.send_getTraceCombosByIds(trace_ids, adjust)
    return self.recv_getTraceCombosByIds()

  def send_getTraceCombosByIds(self, trace_ids, adjust):
    self._oprot.writeMessageBegin('getTraceCombosByIds', TMessageType.CALL, self._seqid)
    args = getTraceCombosByIds_args()
    args.trace_ids = trace_ids
    args.adjust = adjust
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getTraceCombosByIds(self):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getTraceCombosByIds_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.qe is not None:
      raise result.qe
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getTraceCombosByIds failed: unknown result");

  def getServiceNames(self):
    """
    Fetch all the service names we have seen from now all the way back to the set ttl.
    """
    self.send_getServiceNames()
    return self.recv_getServiceNames()

  def send_getServiceNames(self):
    self._oprot.writeMessageBegin('getServiceNames', TMessageType.CALL, self._seqid)
    args = getServiceNames_args()
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getServiceNames(self):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getServiceNames_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.qe is not None:
      raise result.qe
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getServiceNames failed: unknown result");

  def getSpanNames(self, service_name):
    """
    Get all the seen span names for a particular service, from now back until the set ttl.

    Parameters:
     - service_name
    """
    self.send_getSpanNames(service_name)
    return self.recv_getSpanNames()

  def send_getSpanNames(self, service_name):
    self._oprot.writeMessageBegin('getSpanNames', TMessageType.CALL, self._seqid)
    args = getSpanNames_args()
    args.service_name = service_name
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getSpanNames(self):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getSpanNames_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.qe is not None:
      raise result.qe
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getSpanNames failed: unknown result");

  def setTraceTimeToLive(self, trace_id, ttl_seconds):
    """
    Change the TTL of a trace. If we find an interesting trace we want to keep around for further
    investigation.

    Parameters:
     - trace_id
     - ttl_seconds
    """
    self.send_setTraceTimeToLive(trace_id, ttl_seconds)
    self.recv_setTraceTimeToLive()

  def send_setTraceTimeToLive(self, trace_id, ttl_seconds):
    self._oprot.writeMessageBegin('setTraceTimeToLive', TMessageType.CALL, self._seqid)
    args = setTraceTimeToLive_args()
    args.trace_id = trace_id
    args.ttl_seconds = ttl_seconds
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_setTraceTimeToLive(self):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = setTraceTimeToLive_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.qe is not None:
      raise result.qe
    return

  def getTraceTimeToLive(self, trace_id):
    """
    Get the TTL in seconds of a specific trace.

    Parameters:
     - trace_id
    """
    self.send_getTraceTimeToLive(trace_id)
    return self.recv_getTraceTimeToLive()

  def send_getTraceTimeToLive(self, trace_id):
    self._oprot.writeMessageBegin('getTraceTimeToLive', TMessageType.CALL, self._seqid)
    args = getTraceTimeToLive_args()
    args.trace_id = trace_id
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getTraceTimeToLive(self):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getTraceTimeToLive_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.qe is not None:
      raise result.qe
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getTraceTimeToLive failed: unknown result");

  def getDataTimeToLive(self):
    """
    Get the data ttl. This is the number of seconds we keep the data around before deleting it.
    """
    self.send_getDataTimeToLive()
    return self.recv_getDataTimeToLive()

  def send_getDataTimeToLive(self):
    self._oprot.writeMessageBegin('getDataTimeToLive', TMessageType.CALL, self._seqid)
    args = getDataTimeToLive_args()
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getDataTimeToLive(self):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getDataTimeToLive_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.qe is not None:
      raise result.qe
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getDataTimeToLive failed: unknown result");

  def getDependencies(self, start_time, end_time):
    """
    Get an aggregate representation of all services paired with every service they call in to.
    This includes information on call counts and mean/stdDev/etc of call durations.  The two arguments
    specify epoch time in microseconds. The end time is optional and defaults to one day after the
    start time.

    Parameters:
     - start_time
     - end_time
    """
    self.send_getDependencies(start_time, end_time)
    return self.recv_getDependencies()

  def send_getDependencies(self, start_time, end_time):
    self._oprot.writeMessageBegin('getDependencies', TMessageType.CALL, self._seqid)
    args = getDependencies_args()
    args.start_time = start_time
    args.end_time = end_time
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getDependencies(self):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getDependencies_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.qe is not None:
      raise result.qe
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getDependencies failed: unknown result");

  def getTopAnnotations(self, service_name):
    """
    Parameters:
     - service_name
    """
    self.send_getTopAnnotations(service_name)
    return self.recv_getTopAnnotations()

  def send_getTopAnnotations(self, service_name):
    self._oprot.writeMessageBegin('getTopAnnotations', TMessageType.CALL, self._seqid)
    args = getTopAnnotations_args()
    args.service_name = service_name
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getTopAnnotations(self):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getTopAnnotations_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.qe is not None:
      raise result.qe
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getTopAnnotations failed: unknown result");

  def getTopKeyValueAnnotations(self, service_name):
    """
    Parameters:
     - service_name
    """
    self.send_getTopKeyValueAnnotations(service_name)
    return self.recv_getTopKeyValueAnnotations()

  def send_getTopKeyValueAnnotations(self, service_name):
    self._oprot.writeMessageBegin('getTopKeyValueAnnotations', TMessageType.CALL, self._seqid)
    args = getTopKeyValueAnnotations_args()
    args.service_name = service_name
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getTopKeyValueAnnotations(self):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getTopKeyValueAnnotations_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.qe is not None:
      raise result.qe
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getTopKeyValueAnnotations failed: unknown result");

  def getSpanDurations(self, time_stamp, service_name, rpc_name):
    """
    Given a time stamp, server service name, and rpc name, fetch all of the client services calling in paired
    with the lists of every span duration (list<i64>) from the server to client. The lists of span durations
    include information on call counts and mean/stdDev/etc of call durations.

    The three arguments specify epoch time in microseconds, server side service name and rpc name. The return maps
    contains the key - client_service_name and value - list<span_durations>.

    Parameters:
     - time_stamp
     - service_name
     - rpc_name
    """
    self.send_getSpanDurations(time_stamp, service_name, rpc_name)
    return self.recv_getSpanDurations()

  def send_getSpanDurations(self, time_stamp, service_name, rpc_name):
    self._oprot.writeMessageBegin('getSpanDurations', TMessageType.CALL, self._seqid)
    args = getSpanDurations_args()
    args.time_stamp = time_stamp
    args.service_name = service_name
    args.rpc_name = rpc_name
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getSpanDurations(self):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getSpanDurations_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getSpanDurations failed: unknown result");

  def getServiceNamesToTraceIds(self, time_stamp, service_name, rpc_name):
    """
    Given a time stamp, server service name, and rpc name, fetch all of the client services calling in paired
    with the lists of every trace Ids (list<i64>) from the server to client.

    The three arguments specify epoch time in microseconds, server side service name and rpc name. The return maps
    contains the key - client_service_name and value - list<trace_id>.

    Parameters:
     - time_stamp
     - service_name
     - rpc_name
    """
    self.send_getServiceNamesToTraceIds(time_stamp, service_name, rpc_name)
    return self.recv_getServiceNamesToTraceIds()

  def send_getServiceNamesToTraceIds(self, time_stamp, service_name, rpc_name):
    self._oprot.writeMessageBegin('getServiceNamesToTraceIds', TMessageType.CALL, self._seqid)
    args = getServiceNamesToTraceIds_args()
    args.time_stamp = time_stamp
    args.service_name = service_name
    args.rpc_name = rpc_name
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getServiceNamesToTraceIds(self):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getServiceNamesToTraceIds_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getServiceNamesToTraceIds failed: unknown result");


class Processor(Iface, TProcessor):
  def __init__(self, handler):
    self._handler = handler
    self._processMap = {}
    self._processMap["getTraceIds"] = Processor.process_getTraceIds
    self._processMap["getTraceIdsBySpanName"] = Processor.process_getTraceIdsBySpanName
    self._processMap["getTraceIdsByServiceName"] = Processor.process_getTraceIdsByServiceName
    self._processMap["getTraceIdsByAnnotation"] = Processor.process_getTraceIdsByAnnotation
    self._processMap["tracesExist"] = Processor.process_tracesExist
    self._processMap["getTracesByIds"] = Processor.process_getTracesByIds
    self._processMap["getTraceTimelinesByIds"] = Processor.process_getTraceTimelinesByIds
    self._processMap["getTraceSummariesByIds"] = Processor.process_getTraceSummariesByIds
    self._processMap["getTraceCombosByIds"] = Processor.process_getTraceCombosByIds
    self._processMap["getServiceNames"] = Processor.process_getServiceNames
    self._processMap["getSpanNames"] = Processor.process_getSpanNames
    self._processMap["setTraceTimeToLive"] = Processor.process_setTraceTimeToLive
    self._processMap["getTraceTimeToLive"] = Processor.process_getTraceTimeToLive
    self._processMap["getDataTimeToLive"] = Processor.process_getDataTimeToLive
    self._processMap["getDependencies"] = Processor.process_getDependencies
    self._processMap["getTopAnnotations"] = Processor.process_getTopAnnotations
    self._processMap["getTopKeyValueAnnotations"] = Processor.process_getTopKeyValueAnnotations
    self._processMap["getSpanDurations"] = Processor.process_getSpanDurations
    self._processMap["getServiceNamesToTraceIds"] = Processor.process_getServiceNamesToTraceIds

  def process(self, iprot, oprot):
    (name, type, seqid) = iprot.readMessageBegin()
    if name not in self._processMap:
      iprot.skip(TType.STRUCT)
      iprot.readMessageEnd()
      x = TApplicationException(TApplicationException.UNKNOWN_METHOD, 'Unknown function %s' % (name))
      oprot.writeMessageBegin(name, TMessageType.EXCEPTION, seqid)
      x.write(oprot)
      oprot.writeMessageEnd()
      oprot.trans.flush()
      return
    else:
      self._processMap[name](self, seqid, iprot, oprot)
    return True

  def process_getTraceIds(self, seqid, iprot, oprot):
    args = getTraceIds_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getTraceIds_result()
    try:
      result.success = self._handler.getTraceIds(args.request)
    except QueryException, qe:
      result.qe = qe
    oprot.writeMessageBegin("getTraceIds", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getTraceIdsBySpanName(self, seqid, iprot, oprot):
    args = getTraceIdsBySpanName_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getTraceIdsBySpanName_result()
    try:
      result.success = self._handler.getTraceIdsBySpanName(args.service_name, args.span_name, args.end_ts, args.limit, args.order, args.start_ts)
    except QueryException, qe:
      result.qe = qe
    oprot.writeMessageBegin("getTraceIdsBySpanName", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getTraceIdsByServiceName(self, seqid, iprot, oprot):
    args = getTraceIdsByServiceName_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getTraceIdsByServiceName_result()
    try:
      result.success = self._handler.getTraceIdsByServiceName(args.service_name, args.end_ts, args.limit, args.order, args.start_ts)
    except QueryException, qe:
      result.qe = qe
    oprot.writeMessageBegin("getTraceIdsByServiceName", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getTraceIdsByAnnotation(self, seqid, iprot, oprot):
    args = getTraceIdsByAnnotation_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getTraceIdsByAnnotation_result()
    try:
      result.success = self._handler.getTraceIdsByAnnotation(args.service_name, args.annotation, args.value, args.end_ts, args.limit, args.order, args.start_ts)
    except QueryException, qe:
      result.qe = qe
    oprot.writeMessageBegin("getTraceIdsByAnnotation", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_tracesExist(self, seqid, iprot, oprot):
    args = tracesExist_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = tracesExist_result()
    try:
      result.success = self._handler.tracesExist(args.trace_ids)
    except QueryException, qe:
      result.qe = qe
    oprot.writeMessageBegin("tracesExist", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getTracesByIds(self, seqid, iprot, oprot):
    args = getTracesByIds_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getTracesByIds_result()
    try:
      result.success = self._handler.getTracesByIds(args.trace_ids, args.adjust)
    except QueryException, qe:
      result.qe = qe
    oprot.writeMessageBegin("getTracesByIds", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getTraceTimelinesByIds(self, seqid, iprot, oprot):
    args = getTraceTimelinesByIds_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getTraceTimelinesByIds_result()
    try:
      result.success = self._handler.getTraceTimelinesByIds(args.trace_ids, args.adjust)
    except QueryException, qe:
      result.qe = qe
    oprot.writeMessageBegin("getTraceTimelinesByIds", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getTraceSummariesByIds(self, seqid, iprot, oprot):
    args = getTraceSummariesByIds_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getTraceSummariesByIds_result()
    try:
      result.success = self._handler.getTraceSummariesByIds(args.trace_ids, args.adjust)
    except QueryException, qe:
      result.qe = qe
    oprot.writeMessageBegin("getTraceSummariesByIds", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getTraceCombosByIds(self, seqid, iprot, oprot):
    args = getTraceCombosByIds_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getTraceCombosByIds_result()
    try:
      result.success = self._handler.getTraceCombosByIds(args.trace_ids, args.adjust)
    except QueryException, qe:
      result.qe = qe
    oprot.writeMessageBegin("getTraceCombosByIds", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getServiceNames(self, seqid, iprot, oprot):
    args = getServiceNames_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getServiceNames_result()
    try:
      result.success = self._handler.getServiceNames()
    except QueryException, qe:
      result.qe = qe
    oprot.writeMessageBegin("getServiceNames", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getSpanNames(self, seqid, iprot, oprot):
    args = getSpanNames_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getSpanNames_result()
    try:
      result.success = self._handler.getSpanNames(args.service_name)
    except QueryException, qe:
      result.qe = qe
    oprot.writeMessageBegin("getSpanNames", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_setTraceTimeToLive(self, seqid, iprot, oprot):
    args = setTraceTimeToLive_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = setTraceTimeToLive_result()
    try:
      self._handler.setTraceTimeToLive(args.trace_id, args.ttl_seconds)
    except QueryException, qe:
      result.qe = qe
    oprot.writeMessageBegin("setTraceTimeToLive", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getTraceTimeToLive(self, seqid, iprot, oprot):
    args = getTraceTimeToLive_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getTraceTimeToLive_result()
    try:
      result.success = self._handler.getTraceTimeToLive(args.trace_id)
    except QueryException, qe:
      result.qe = qe
    oprot.writeMessageBegin("getTraceTimeToLive", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getDataTimeToLive(self, seqid, iprot, oprot):
    args = getDataTimeToLive_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getDataTimeToLive_result()
    try:
      result.success = self._handler.getDataTimeToLive()
    except QueryException, qe:
      result.qe = qe
    oprot.writeMessageBegin("getDataTimeToLive", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getDependencies(self, seqid, iprot, oprot):
    args = getDependencies_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getDependencies_result()
    try:
      result.success = self._handler.getDependencies(args.start_time, args.end_time)
    except QueryException, qe:
      result.qe = qe
    oprot.writeMessageBegin("getDependencies", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getTopAnnotations(self, seqid, iprot, oprot):
    args = getTopAnnotations_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getTopAnnotations_result()
    try:
      result.success = self._handler.getTopAnnotations(args.service_name)
    except QueryException, qe:
      result.qe = qe
    oprot.writeMessageBegin("getTopAnnotations", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getTopKeyValueAnnotations(self, seqid, iprot, oprot):
    args = getTopKeyValueAnnotations_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getTopKeyValueAnnotations_result()
    try:
      result.success = self._handler.getTopKeyValueAnnotations(args.service_name)
    except QueryException, qe:
      result.qe = qe
    oprot.writeMessageBegin("getTopKeyValueAnnotations", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getSpanDurations(self, seqid, iprot, oprot):
    args = getSpanDurations_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getSpanDurations_result()
    result.success = self._handler.getSpanDurations(args.time_stamp, args.service_name, args.rpc_name)
    oprot.writeMessageBegin("getSpanDurations", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getServiceNamesToTraceIds(self, seqid, iprot, oprot):
    args = getServiceNamesToTraceIds_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getServiceNamesToTraceIds_result()
    result.success = self._handler.getServiceNamesToTraceIds(args.time_stamp, args.service_name, args.rpc_name)
    oprot.writeMessageBegin("getServiceNamesToTraceIds", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()


# HELPER FUNCTIONS AND STRUCTURES

class getTraceIds_args:
  """
  Attributes:
   - request
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'request', (QueryRequest, QueryRequest.thrift_spec), None, ), # 1
  )

  def __init__(self, request=None,):
    self.request = request

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.request = QueryRequest()
          self.request.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getTraceIds_args')
    if self.request is not None:
      oprot.writeFieldBegin('request', TType.STRUCT, 1)
      self.request.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getTraceIds_result:
  """
  Attributes:
   - success
   - qe
  """

  thrift_spec = (
    (0, TType.STRUCT, 'success', (QueryResponse, QueryResponse.thrift_spec), None, ), # 0
    (1, TType.STRUCT, 'qe', (QueryException, QueryException.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, qe=None,):
    self.success = success
    self.qe = qe

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRUCT:
          self.success = QueryResponse()
          self.success.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.qe = QueryException()
          self.qe.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getTraceIds_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRUCT, 0)
      self.success.write(oprot)
      oprot.writeFieldEnd()
    if self.qe is not None:
      oprot.writeFieldBegin('qe', TType.STRUCT, 1)
      self.qe.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getTraceIdsBySpanName_args:
  """
  Attributes:
   - service_name
   - span_name
   - end_ts
   - limit
   - order
   - start_ts
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'service_name', None, None, ), # 1
    (2, TType.STRING, 'span_name', None, None, ), # 2
    None, # 3
    (4, TType.I64, 'end_ts', None, None, ), # 4
    (5, TType.I32, 'limit', None, None, ), # 5
    (6, TType.I32, 'order', None, None, ), # 6
    (7, TType.I64, 'start_ts', None, 0, ), # 7
  )

  def __init__(self, service_name=None, span_name=None, end_ts=None, limit=None, order=None, start_ts=thrift_spec[7][4],):
    self.service_name = service_name
    self.span_name = span_name
    self.end_ts = end_ts
    self.limit = limit
    self.order = order
    self.start_ts = start_ts

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.service_name = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.span_name = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.I64:
          self.end_ts = iprot.readI64();
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.I32:
          self.limit = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 6:
        if ftype == TType.I32:
          self.order = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 7:
        if ftype == TType.I64:
          self.start_ts = iprot.readI64();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getTraceIdsBySpanName_args')
    if self.service_name is not None:
      oprot.writeFieldBegin('service_name', TType.STRING, 1)
      oprot.writeString(self.service_name)
      oprot.writeFieldEnd()
    if self.span_name is not None:
      oprot.writeFieldBegin('span_name', TType.STRING, 2)
      oprot.writeString(self.span_name)
      oprot.writeFieldEnd()
    if self.end_ts is not None:
      oprot.writeFieldBegin('end_ts', TType.I64, 4)
      oprot.writeI64(self.end_ts)
      oprot.writeFieldEnd()
    if self.limit is not None:
      oprot.writeFieldBegin('limit', TType.I32, 5)
      oprot.writeI32(self.limit)
      oprot.writeFieldEnd()
    if self.order is not None:
      oprot.writeFieldBegin('order', TType.I32, 6)
      oprot.writeI32(self.order)
      oprot.writeFieldEnd()
    if self.start_ts is not None:
      oprot.writeFieldBegin('start_ts', TType.I64, 7)
      oprot.writeI64(self.start_ts)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getTraceIdsBySpanName_result:
  """
  Attributes:
   - success
   - qe
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.I64,None), None, ), # 0
    (1, TType.STRUCT, 'qe', (QueryException, QueryException.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, qe=None,):
    self.success = success
    self.qe = qe

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype70, _size67) = iprot.readListBegin()
          for _i71 in xrange(_size67):
            _elem72 = iprot.readI64();
            self.success.append(_elem72)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.qe = QueryException()
          self.qe.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getTraceIdsBySpanName_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.I64, len(self.success))
      for iter73 in self.success:
        oprot.writeI64(iter73)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.qe is not None:
      oprot.writeFieldBegin('qe', TType.STRUCT, 1)
      self.qe.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getTraceIdsByServiceName_args:
  """
  Attributes:
   - service_name
   - end_ts
   - limit
   - order
   - start_ts
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'service_name', None, None, ), # 1
    None, # 2
    (3, TType.I64, 'end_ts', None, None, ), # 3
    (4, TType.I32, 'limit', None, None, ), # 4
    (5, TType.I32, 'order', None, None, ), # 5
    (6, TType.I64, 'start_ts', None, 0, ), # 6
  )

  def __init__(self, service_name=None, end_ts=None, limit=None, order=None, start_ts=thrift_spec[6][4],):
    self.service_name = service_name
    self.end_ts = end_ts
    self.limit = limit
    self.order = order
    self.start_ts = start_ts

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.service_name = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.I64:
          self.end_ts = iprot.readI64();
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.I32:
          self.limit = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.I32:
          self.order = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 6:
        if ftype == TType.I64:
          self.start_ts = iprot.readI64();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getTraceIdsByServiceName_args')
    if self.service_name is not None:
      oprot.writeFieldBegin('service_name', TType.STRING, 1)
      oprot.writeString(self.service_name)
      oprot.writeFieldEnd()
    if self.end_ts is not None:
      oprot.writeFieldBegin('end_ts', TType.I64, 3)
      oprot.writeI64(self.end_ts)
      oprot.writeFieldEnd()
    if self.limit is not None:
      oprot.writeFieldBegin('limit', TType.I32, 4)
      oprot.writeI32(self.limit)
      oprot.writeFieldEnd()
    if self.order is not None:
      oprot.writeFieldBegin('order', TType.I32, 5)
      oprot.writeI32(self.order)
      oprot.writeFieldEnd()
    if self.start_ts is not None:
      oprot.writeFieldBegin('start_ts', TType.I64, 6)
      oprot.writeI64(self.start_ts)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getTraceIdsByServiceName_result:
  """
  Attributes:
   - success
   - qe
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.I64,None), None, ), # 0
    (1, TType.STRUCT, 'qe', (QueryException, QueryException.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, qe=None,):
    self.success = success
    self.qe = qe

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype77, _size74) = iprot.readListBegin()
          for _i78 in xrange(_size74):
            _elem79 = iprot.readI64();
            self.success.append(_elem79)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.qe = QueryException()
          self.qe.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getTraceIdsByServiceName_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.I64, len(self.success))
      for iter80 in self.success:
        oprot.writeI64(iter80)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.qe is not None:
      oprot.writeFieldBegin('qe', TType.STRUCT, 1)
      self.qe.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getTraceIdsByAnnotation_args:
  """
  Attributes:
   - service_name
   - annotation
   - value
   - end_ts
   - limit
   - order
   - start_ts
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'service_name', None, None, ), # 1
    (2, TType.STRING, 'annotation', None, None, ), # 2
    (3, TType.STRING, 'value', None, None, ), # 3
    None, # 4
    (5, TType.I64, 'end_ts', None, None, ), # 5
    (6, TType.I32, 'limit', None, None, ), # 6
    (7, TType.I32, 'order', None, None, ), # 7
    (8, TType.I64, 'start_ts', None, None, ), # 8
  )

  def __init__(self, service_name=None, annotation=None, value=None, end_ts=None, limit=None, order=None, start_ts=None,):
    self.service_name = service_name
    self.annotation = annotation
    self.value = value
    self.end_ts = end_ts
    self.limit = limit
    self.order = order
    self.start_ts = start_ts

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.service_name = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.annotation = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRING:
          self.value = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.I64:
          self.end_ts = iprot.readI64();
        else:
          iprot.skip(ftype)
      elif fid == 6:
        if ftype == TType.I32:
          self.limit = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 7:
        if ftype == TType.I32:
          self.order = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 8:
        if ftype == TType.I64:
          self.start_ts = iprot.readI64();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getTraceIdsByAnnotation_args')
    if self.service_name is not None:
      oprot.writeFieldBegin('service_name', TType.STRING, 1)
      oprot.writeString(self.service_name)
      oprot.writeFieldEnd()
    if self.annotation is not None:
      oprot.writeFieldBegin('annotation', TType.STRING, 2)
      oprot.writeString(self.annotation)
      oprot.writeFieldEnd()
    if self.value is not None:
      oprot.writeFieldBegin('value', TType.STRING, 3)
      oprot.writeString(self.value)
      oprot.writeFieldEnd()
    if self.end_ts is not None:
      oprot.writeFieldBegin('end_ts', TType.I64, 5)
      oprot.writeI64(self.end_ts)
      oprot.writeFieldEnd()
    if self.limit is not None:
      oprot.writeFieldBegin('limit', TType.I32, 6)
      oprot.writeI32(self.limit)
      oprot.writeFieldEnd()
    if self.order is not None:
      oprot.writeFieldBegin('order', TType.I32, 7)
      oprot.writeI32(self.order)
      oprot.writeFieldEnd()
    if self.start_ts is not None:
      oprot.writeFieldBegin('start_ts', TType.I64, 8)
      oprot.writeI64(self.start_ts)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getTraceIdsByAnnotation_result:
  """
  Attributes:
   - success
   - qe
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.I64,None), None, ), # 0
    (1, TType.STRUCT, 'qe', (QueryException, QueryException.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, qe=None,):
    self.success = success
    self.qe = qe

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype84, _size81) = iprot.readListBegin()
          for _i85 in xrange(_size81):
            _elem86 = iprot.readI64();
            self.success.append(_elem86)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.qe = QueryException()
          self.qe.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getTraceIdsByAnnotation_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.I64, len(self.success))
      for iter87 in self.success:
        oprot.writeI64(iter87)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.qe is not None:
      oprot.writeFieldBegin('qe', TType.STRUCT, 1)
      self.qe.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class tracesExist_args:
  """
  Attributes:
   - trace_ids
  """

  thrift_spec = (
    None, # 0
    (1, TType.LIST, 'trace_ids', (TType.I64,None), None, ), # 1
  )

  def __init__(self, trace_ids=None,):
    self.trace_ids = trace_ids

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.LIST:
          self.trace_ids = []
          (_etype91, _size88) = iprot.readListBegin()
          for _i92 in xrange(_size88):
            _elem93 = iprot.readI64();
            self.trace_ids.append(_elem93)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('tracesExist_args')
    if self.trace_ids is not None:
      oprot.writeFieldBegin('trace_ids', TType.LIST, 1)
      oprot.writeListBegin(TType.I64, len(self.trace_ids))
      for iter94 in self.trace_ids:
        oprot.writeI64(iter94)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class tracesExist_result:
  """
  Attributes:
   - success
   - qe
  """

  thrift_spec = (
    (0, TType.SET, 'success', (TType.I64,None), None, ), # 0
    (1, TType.STRUCT, 'qe', (QueryException, QueryException.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, qe=None,):
    self.success = success
    self.qe = qe

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.SET:
          self.success = set()
          (_etype98, _size95) = iprot.readSetBegin()
          for _i99 in xrange(_size95):
            _elem100 = iprot.readI64();
            self.success.add(_elem100)
          iprot.readSetEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.qe = QueryException()
          self.qe.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('tracesExist_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.SET, 0)
      oprot.writeSetBegin(TType.I64, len(self.success))
      for iter101 in self.success:
        oprot.writeI64(iter101)
      oprot.writeSetEnd()
      oprot.writeFieldEnd()
    if self.qe is not None:
      oprot.writeFieldBegin('qe', TType.STRUCT, 1)
      self.qe.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getTracesByIds_args:
  """
  Attributes:
   - trace_ids
   - adjust
  """

  thrift_spec = (
    None, # 0
    (1, TType.LIST, 'trace_ids', (TType.I64,None), None, ), # 1
    (2, TType.LIST, 'adjust', (TType.I32,None), None, ), # 2
  )

  def __init__(self, trace_ids=None, adjust=None,):
    self.trace_ids = trace_ids
    self.adjust = adjust

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.LIST:
          self.trace_ids = []
          (_etype105, _size102) = iprot.readListBegin()
          for _i106 in xrange(_size102):
            _elem107 = iprot.readI64();
            self.trace_ids.append(_elem107)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.LIST:
          self.adjust = []
          (_etype111, _size108) = iprot.readListBegin()
          for _i112 in xrange(_size108):
            _elem113 = iprot.readI32();
            self.adjust.append(_elem113)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getTracesByIds_args')
    if self.trace_ids is not None:
      oprot.writeFieldBegin('trace_ids', TType.LIST, 1)
      oprot.writeListBegin(TType.I64, len(self.trace_ids))
      for iter114 in self.trace_ids:
        oprot.writeI64(iter114)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.adjust is not None:
      oprot.writeFieldBegin('adjust', TType.LIST, 2)
      oprot.writeListBegin(TType.I32, len(self.adjust))
      for iter115 in self.adjust:
        oprot.writeI32(iter115)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getTracesByIds_result:
  """
  Attributes:
   - success
   - qe
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT,(Trace, Trace.thrift_spec)), None, ), # 0
    (1, TType.STRUCT, 'qe', (QueryException, QueryException.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, qe=None,):
    self.success = success
    self.qe = qe

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype119, _size116) = iprot.readListBegin()
          for _i120 in xrange(_size116):
            _elem121 = Trace()
            _elem121.read(iprot)
            self.success.append(_elem121)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.qe = QueryException()
          self.qe.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getTracesByIds_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.STRUCT, len(self.success))
      for iter122 in self.success:
        iter122.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.qe is not None:
      oprot.writeFieldBegin('qe', TType.STRUCT, 1)
      self.qe.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getTraceTimelinesByIds_args:
  """
  Attributes:
   - trace_ids
   - adjust
  """

  thrift_spec = (
    None, # 0
    (1, TType.LIST, 'trace_ids', (TType.I64,None), None, ), # 1
    (2, TType.LIST, 'adjust', (TType.I32,None), None, ), # 2
  )

  def __init__(self, trace_ids=None, adjust=None,):
    self.trace_ids = trace_ids
    self.adjust = adjust

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.LIST:
          self.trace_ids = []
          (_etype126, _size123) = iprot.readListBegin()
          for _i127 in xrange(_size123):
            _elem128 = iprot.readI64();
            self.trace_ids.append(_elem128)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.LIST:
          self.adjust = []
          (_etype132, _size129) = iprot.readListBegin()
          for _i133 in xrange(_size129):
            _elem134 = iprot.readI32();
            self.adjust.append(_elem134)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getTraceTimelinesByIds_args')
    if self.trace_ids is not None:
      oprot.writeFieldBegin('trace_ids', TType.LIST, 1)
      oprot.writeListBegin(TType.I64, len(self.trace_ids))
      for iter135 in self.trace_ids:
        oprot.writeI64(iter135)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.adjust is not None:
      oprot.writeFieldBegin('adjust', TType.LIST, 2)
      oprot.writeListBegin(TType.I32, len(self.adjust))
      for iter136 in self.adjust:
        oprot.writeI32(iter136)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getTraceTimelinesByIds_result:
  """
  Attributes:
   - success
   - qe
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT,(TraceTimeline, TraceTimeline.thrift_spec)), None, ), # 0
    (1, TType.STRUCT, 'qe', (QueryException, QueryException.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, qe=None,):
    self.success = success
    self.qe = qe

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype140, _size137) = iprot.readListBegin()
          for _i141 in xrange(_size137):
            _elem142 = TraceTimeline()
            _elem142.read(iprot)
            self.success.append(_elem142)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.qe = QueryException()
          self.qe.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getTraceTimelinesByIds_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.STRUCT, len(self.success))
      for iter143 in self.success:
        iter143.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.qe is not None:
      oprot.writeFieldBegin('qe', TType.STRUCT, 1)
      self.qe.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getTraceSummariesByIds_args:
  """
  Attributes:
   - trace_ids
   - adjust
  """

  thrift_spec = (
    None, # 0
    (1, TType.LIST, 'trace_ids', (TType.I64,None), None, ), # 1
    (2, TType.LIST, 'adjust', (TType.I32,None), None, ), # 2
  )

  def __init__(self, trace_ids=None, adjust=None,):
    self.trace_ids = trace_ids
    self.adjust = adjust

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.LIST:
          self.trace_ids = []
          (_etype147, _size144) = iprot.readListBegin()
          for _i148 in xrange(_size144):
            _elem149 = iprot.readI64();
            self.trace_ids.append(_elem149)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.LIST:
          self.adjust = []
          (_etype153, _size150) = iprot.readListBegin()
          for _i154 in xrange(_size150):
            _elem155 = iprot.readI32();
            self.adjust.append(_elem155)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getTraceSummariesByIds_args')
    if self.trace_ids is not None:
      oprot.writeFieldBegin('trace_ids', TType.LIST, 1)
      oprot.writeListBegin(TType.I64, len(self.trace_ids))
      for iter156 in self.trace_ids:
        oprot.writeI64(iter156)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.adjust is not None:
      oprot.writeFieldBegin('adjust', TType.LIST, 2)
      oprot.writeListBegin(TType.I32, len(self.adjust))
      for iter157 in self.adjust:
        oprot.writeI32(iter157)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getTraceSummariesByIds_result:
  """
  Attributes:
   - success
   - qe
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT,(TraceSummary, TraceSummary.thrift_spec)), None, ), # 0
    (1, TType.STRUCT, 'qe', (QueryException, QueryException.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, qe=None,):
    self.success = success
    self.qe = qe

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype161, _size158) = iprot.readListBegin()
          for _i162 in xrange(_size158):
            _elem163 = TraceSummary()
            _elem163.read(iprot)
            self.success.append(_elem163)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.qe = QueryException()
          self.qe.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getTraceSummariesByIds_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.STRUCT, len(self.success))
      for iter164 in self.success:
        iter164.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.qe is not None:
      oprot.writeFieldBegin('qe', TType.STRUCT, 1)
      self.qe.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getTraceCombosByIds_args:
  """
  Attributes:
   - trace_ids
   - adjust
  """

  thrift_spec = (
    None, # 0
    (1, TType.LIST, 'trace_ids', (TType.I64,None), None, ), # 1
    (2, TType.LIST, 'adjust', (TType.I32,None), None, ), # 2
  )

  def __init__(self, trace_ids=None, adjust=None,):
    self.trace_ids = trace_ids
    self.adjust = adjust

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.LIST:
          self.trace_ids = []
          (_etype168, _size165) = iprot.readListBegin()
          for _i169 in xrange(_size165):
            _elem170 = iprot.readI64();
            self.trace_ids.append(_elem170)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.LIST:
          self.adjust = []
          (_etype174, _size171) = iprot.readListBegin()
          for _i175 in xrange(_size171):
            _elem176 = iprot.readI32();
            self.adjust.append(_elem176)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getTraceCombosByIds_args')
    if self.trace_ids is not None:
      oprot.writeFieldBegin('trace_ids', TType.LIST, 1)
      oprot.writeListBegin(TType.I64, len(self.trace_ids))
      for iter177 in self.trace_ids:
        oprot.writeI64(iter177)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.adjust is not None:
      oprot.writeFieldBegin('adjust', TType.LIST, 2)
      oprot.writeListBegin(TType.I32, len(self.adjust))
      for iter178 in self.adjust:
        oprot.writeI32(iter178)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getTraceCombosByIds_result:
  """
  Attributes:
   - success
   - qe
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT,(TraceCombo, TraceCombo.thrift_spec)), None, ), # 0
    (1, TType.STRUCT, 'qe', (QueryException, QueryException.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, qe=None,):
    self.success = success
    self.qe = qe

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype182, _size179) = iprot.readListBegin()
          for _i183 in xrange(_size179):
            _elem184 = TraceCombo()
            _elem184.read(iprot)
            self.success.append(_elem184)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.qe = QueryException()
          self.qe.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getTraceCombosByIds_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.STRUCT, len(self.success))
      for iter185 in self.success:
        iter185.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.qe is not None:
      oprot.writeFieldBegin('qe', TType.STRUCT, 1)
      self.qe.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getServiceNames_args:

  thrift_spec = (
  )

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getServiceNames_args')
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getServiceNames_result:
  """
  Attributes:
   - success
   - qe
  """

  thrift_spec = (
    (0, TType.SET, 'success', (TType.STRING,None), None, ), # 0
    (1, TType.STRUCT, 'qe', (QueryException, QueryException.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, qe=None,):
    self.success = success
    self.qe = qe

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.SET:
          self.success = set()
          (_etype189, _size186) = iprot.readSetBegin()
          for _i190 in xrange(_size186):
            _elem191 = iprot.readString();
            self.success.add(_elem191)
          iprot.readSetEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.qe = QueryException()
          self.qe.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getServiceNames_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.SET, 0)
      oprot.writeSetBegin(TType.STRING, len(self.success))
      for iter192 in self.success:
        oprot.writeString(iter192)
      oprot.writeSetEnd()
      oprot.writeFieldEnd()
    if self.qe is not None:
      oprot.writeFieldBegin('qe', TType.STRUCT, 1)
      self.qe.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getSpanNames_args:
  """
  Attributes:
   - service_name
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'service_name', None, None, ), # 1
  )

  def __init__(self, service_name=None,):
    self.service_name = service_name

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.service_name = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getSpanNames_args')
    if self.service_name is not None:
      oprot.writeFieldBegin('service_name', TType.STRING, 1)
      oprot.writeString(self.service_name)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getSpanNames_result:
  """
  Attributes:
   - success
   - qe
  """

  thrift_spec = (
    (0, TType.SET, 'success', (TType.STRING,None), None, ), # 0
    (1, TType.STRUCT, 'qe', (QueryException, QueryException.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, qe=None,):
    self.success = success
    self.qe = qe

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.SET:
          self.success = set()
          (_etype196, _size193) = iprot.readSetBegin()
          for _i197 in xrange(_size193):
            _elem198 = iprot.readString();
            self.success.add(_elem198)
          iprot.readSetEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.qe = QueryException()
          self.qe.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getSpanNames_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.SET, 0)
      oprot.writeSetBegin(TType.STRING, len(self.success))
      for iter199 in self.success:
        oprot.writeString(iter199)
      oprot.writeSetEnd()
      oprot.writeFieldEnd()
    if self.qe is not None:
      oprot.writeFieldBegin('qe', TType.STRUCT, 1)
      self.qe.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class setTraceTimeToLive_args:
  """
  Attributes:
   - trace_id
   - ttl_seconds
  """

  thrift_spec = (
    None, # 0
    (1, TType.I64, 'trace_id', None, None, ), # 1
    (2, TType.I32, 'ttl_seconds', None, None, ), # 2
  )

  def __init__(self, trace_id=None, ttl_seconds=None,):
    self.trace_id = trace_id
    self.ttl_seconds = ttl_seconds

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.I64:
          self.trace_id = iprot.readI64();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.I32:
          self.ttl_seconds = iprot.readI32();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('setTraceTimeToLive_args')
    if self.trace_id is not None:
      oprot.writeFieldBegin('trace_id', TType.I64, 1)
      oprot.writeI64(self.trace_id)
      oprot.writeFieldEnd()
    if self.ttl_seconds is not None:
      oprot.writeFieldBegin('ttl_seconds', TType.I32, 2)
      oprot.writeI32(self.ttl_seconds)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class setTraceTimeToLive_result:
  """
  Attributes:
   - qe
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'qe', (QueryException, QueryException.thrift_spec), None, ), # 1
  )

  def __init__(self, qe=None,):
    self.qe = qe

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.qe = QueryException()
          self.qe.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('setTraceTimeToLive_result')
    if self.qe is not None:
      oprot.writeFieldBegin('qe', TType.STRUCT, 1)
      self.qe.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getTraceTimeToLive_args:
  """
  Attributes:
   - trace_id
  """

  thrift_spec = (
    None, # 0
    (1, TType.I64, 'trace_id', None, None, ), # 1
  )

  def __init__(self, trace_id=None,):
    self.trace_id = trace_id

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.I64:
          self.trace_id = iprot.readI64();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getTraceTimeToLive_args')
    if self.trace_id is not None:
      oprot.writeFieldBegin('trace_id', TType.I64, 1)
      oprot.writeI64(self.trace_id)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getTraceTimeToLive_result:
  """
  Attributes:
   - success
   - qe
  """

  thrift_spec = (
    (0, TType.I32, 'success', None, None, ), # 0
    (1, TType.STRUCT, 'qe', (QueryException, QueryException.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, qe=None,):
    self.success = success
    self.qe = qe

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.I32:
          self.success = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.qe = QueryException()
          self.qe.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getTraceTimeToLive_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.I32, 0)
      oprot.writeI32(self.success)
      oprot.writeFieldEnd()
    if self.qe is not None:
      oprot.writeFieldBegin('qe', TType.STRUCT, 1)
      self.qe.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getDataTimeToLive_args:

  thrift_spec = (
  )

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getDataTimeToLive_args')
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getDataTimeToLive_result:
  """
  Attributes:
   - success
   - qe
  """

  thrift_spec = (
    (0, TType.I32, 'success', None, None, ), # 0
    (1, TType.STRUCT, 'qe', (QueryException, QueryException.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, qe=None,):
    self.success = success
    self.qe = qe

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.I32:
          self.success = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.qe = QueryException()
          self.qe.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getDataTimeToLive_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.I32, 0)
      oprot.writeI32(self.success)
      oprot.writeFieldEnd()
    if self.qe is not None:
      oprot.writeFieldBegin('qe', TType.STRUCT, 1)
      self.qe.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getDependencies_args:
  """
  Attributes:
   - start_time
   - end_time
  """

  thrift_spec = (
    None, # 0
    (1, TType.I64, 'start_time', None, None, ), # 1
    (2, TType.I64, 'end_time', None, None, ), # 2
  )

  def __init__(self, start_time=None, end_time=None,):
    self.start_time = start_time
    self.end_time = end_time

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.I64:
          self.start_time = iprot.readI64();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.I64:
          self.end_time = iprot.readI64();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getDependencies_args')
    if self.start_time is not None:
      oprot.writeFieldBegin('start_time', TType.I64, 1)
      oprot.writeI64(self.start_time)
      oprot.writeFieldEnd()
    if self.end_time is not None:
      oprot.writeFieldBegin('end_time', TType.I64, 2)
      oprot.writeI64(self.end_time)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getDependencies_result:
  """
  Attributes:
   - success
   - qe
  """

  thrift_spec = (
    (0, TType.STRUCT, 'success', (zipkinDependencies.ttypes.Dependencies, zipkinDependencies.ttypes.Dependencies.thrift_spec), None, ), # 0
    (1, TType.STRUCT, 'qe', (QueryException, QueryException.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, qe=None,):
    self.success = success
    self.qe = qe

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRUCT:
          self.success = zipkinDependencies.ttypes.Dependencies()
          self.success.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.qe = QueryException()
          self.qe.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getDependencies_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRUCT, 0)
      self.success.write(oprot)
      oprot.writeFieldEnd()
    if self.qe is not None:
      oprot.writeFieldBegin('qe', TType.STRUCT, 1)
      self.qe.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getTopAnnotations_args:
  """
  Attributes:
   - service_name
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'service_name', None, None, ), # 1
  )

  def __init__(self, service_name=None,):
    self.service_name = service_name

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.service_name = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getTopAnnotations_args')
    if self.service_name is not None:
      oprot.writeFieldBegin('service_name', TType.STRING, 1)
      oprot.writeString(self.service_name)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getTopAnnotations_result:
  """
  Attributes:
   - success
   - qe
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRING,None), None, ), # 0
    (1, TType.STRUCT, 'qe', (QueryException, QueryException.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, qe=None,):
    self.success = success
    self.qe = qe

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype203, _size200) = iprot.readListBegin()
          for _i204 in xrange(_size200):
            _elem205 = iprot.readString();
            self.success.append(_elem205)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.qe = QueryException()
          self.qe.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getTopAnnotations_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.STRING, len(self.success))
      for iter206 in self.success:
        oprot.writeString(iter206)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.qe is not None:
      oprot.writeFieldBegin('qe', TType.STRUCT, 1)
      self.qe.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getTopKeyValueAnnotations_args:
  """
  Attributes:
   - service_name
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'service_name', None, None, ), # 1
  )

  def __init__(self, service_name=None,):
    self.service_name = service_name

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.service_name = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getTopKeyValueAnnotations_args')
    if self.service_name is not None:
      oprot.writeFieldBegin('service_name', TType.STRING, 1)
      oprot.writeString(self.service_name)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getTopKeyValueAnnotations_result:
  """
  Attributes:
   - success
   - qe
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRING,None), None, ), # 0
    (1, TType.STRUCT, 'qe', (QueryException, QueryException.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, qe=None,):
    self.success = success
    self.qe = qe

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype210, _size207) = iprot.readListBegin()
          for _i211 in xrange(_size207):
            _elem212 = iprot.readString();
            self.success.append(_elem212)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.qe = QueryException()
          self.qe.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getTopKeyValueAnnotations_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.STRING, len(self.success))
      for iter213 in self.success:
        oprot.writeString(iter213)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.qe is not None:
      oprot.writeFieldBegin('qe', TType.STRUCT, 1)
      self.qe.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getSpanDurations_args:
  """
  Attributes:
   - time_stamp
   - service_name
   - rpc_name
  """

  thrift_spec = (
    None, # 0
    (1, TType.I64, 'time_stamp', None, None, ), # 1
    (2, TType.STRING, 'service_name', None, None, ), # 2
    (3, TType.STRING, 'rpc_name', None, None, ), # 3
  )

  def __init__(self, time_stamp=None, service_name=None, rpc_name=None,):
    self.time_stamp = time_stamp
    self.service_name = service_name
    self.rpc_name = rpc_name

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.I64:
          self.time_stamp = iprot.readI64();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.service_name = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRING:
          self.rpc_name = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getSpanDurations_args')
    if self.time_stamp is not None:
      oprot.writeFieldBegin('time_stamp', TType.I64, 1)
      oprot.writeI64(self.time_stamp)
      oprot.writeFieldEnd()
    if self.service_name is not None:
      oprot.writeFieldBegin('service_name', TType.STRING, 2)
      oprot.writeString(self.service_name)
      oprot.writeFieldEnd()
    if self.rpc_name is not None:
      oprot.writeFieldBegin('rpc_name', TType.STRING, 3)
      oprot.writeString(self.rpc_name)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getSpanDurations_result:
  """
  Attributes:
   - success
  """

  thrift_spec = (
    (0, TType.MAP, 'success', (TType.STRING,None,TType.LIST,(TType.I64,None)), None, ), # 0
  )

  def __init__(self, success=None,):
    self.success = success

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.MAP:
          self.success = {}
          (_ktype215, _vtype216, _size214 ) = iprot.readMapBegin()
          for _i218 in xrange(_size214):
            _key219 = iprot.readString();
            _val220 = []
            (_etype224, _size221) = iprot.readListBegin()
            for _i225 in xrange(_size221):
              _elem226 = iprot.readI64();
              _val220.append(_elem226)
            iprot.readListEnd()
            self.success[_key219] = _val220
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getSpanDurations_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.MAP, 0)
      oprot.writeMapBegin(TType.STRING, TType.LIST, len(self.success))
      for kiter227,viter228 in self.success.items():
        oprot.writeString(kiter227)
        oprot.writeListBegin(TType.I64, len(viter228))
        for iter229 in viter228:
          oprot.writeI64(iter229)
        oprot.writeListEnd()
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getServiceNamesToTraceIds_args:
  """
  Attributes:
   - time_stamp
   - service_name
   - rpc_name
  """

  thrift_spec = (
    None, # 0
    (1, TType.I64, 'time_stamp', None, None, ), # 1
    (2, TType.STRING, 'service_name', None, None, ), # 2
    (3, TType.STRING, 'rpc_name', None, None, ), # 3
  )

  def __init__(self, time_stamp=None, service_name=None, rpc_name=None,):
    self.time_stamp = time_stamp
    self.service_name = service_name
    self.rpc_name = rpc_name

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.I64:
          self.time_stamp = iprot.readI64();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.service_name = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRING:
          self.rpc_name = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getServiceNamesToTraceIds_args')
    if self.time_stamp is not None:
      oprot.writeFieldBegin('time_stamp', TType.I64, 1)
      oprot.writeI64(self.time_stamp)
      oprot.writeFieldEnd()
    if self.service_name is not None:
      oprot.writeFieldBegin('service_name', TType.STRING, 2)
      oprot.writeString(self.service_name)
      oprot.writeFieldEnd()
    if self.rpc_name is not None:
      oprot.writeFieldBegin('rpc_name', TType.STRING, 3)
      oprot.writeString(self.rpc_name)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getServiceNamesToTraceIds_result:
  """
  Attributes:
   - success
  """

  thrift_spec = (
    (0, TType.MAP, 'success', (TType.STRING,None,TType.LIST,(TType.I64,None)), None, ), # 0
  )

  def __init__(self, success=None,):
    self.success = success

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.MAP:
          self.success = {}
          (_ktype231, _vtype232, _size230 ) = iprot.readMapBegin()
          for _i234 in xrange(_size230):
            _key235 = iprot.readString();
            _val236 = []
            (_etype240, _size237) = iprot.readListBegin()
            for _i241 in xrange(_size237):
              _elem242 = iprot.readI64();
              _val236.append(_elem242)
            iprot.readListEnd()
            self.success[_key235] = _val236
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getServiceNamesToTraceIds_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.MAP, 0)
      oprot.writeMapBegin(TType.STRING, TType.LIST, len(self.success))
      for kiter243,viter244 in self.success.items():
        oprot.writeString(kiter243)
        oprot.writeListBegin(TType.I64, len(viter244))
        for iter245 in viter244:
          oprot.writeI64(iter245)
        oprot.writeListEnd()
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)
