from ._cffi import zmq_version
import errno

EAGAIN = errno.EAGAIN

NOBLOCK = 1

EINVAL = 1

PAIR = 0
PUB = 1
SUB = 2
REQ = 3
REP = 4
XREQ = 5
XREP = 6
PULL = 7
PUSH = 8
XPUB = 9
XSUB = 10
ROUTER = 11
DEALER = 12
AFFINITY = 4
IDENTITY = 5
SUBSCRIBE = 6
UNSUBSCRIBE = 7
RATE = 8
RECOVERY_IVL = 9
SNDBUF = 11
RCVBUF = 12
RCVMORE = 13
FD = 14
EVENTS = 15
TYPE = 16
LINGER = 17
RECONNECT_IVL = 18
BACKLOG = 19
RECONNECT_IVL_MAX = 21
MAXMSGSIZE = 22
SNDHWM = ZMQ_SNDHWM = 23
RCVHWM = ZMQ_RCVHWM = 24
MULTICAST_HOPS = 25
RCVTIMEO = 27
SNDTIMEO = 28
RCVLABEL = 29

DONTWAIT = 1
SNDMORE = 2
SNDLABEL = 4

POLLIN = 1
POLLOUT = 2
POLLERR = 4

ZMQ_HWM = 1
ZMQ_SWAP = 3
ZMQ_AFFINITY = 4
ZMQ_IDENTITY = 5
ZMQ_SUBSCRIBE = 6
ZMQ_UNSUBSCRIBE = 7
ZMQ_RATE = 8
ZMQ_RECOVERY_IVL = 9
ZMQ_MCAST_LOOP = 10
ZMQ_SNDBUF = 11
ZMQ_RCVBUF = 12
ZMQ_RCVMORE = 13
ZMQ_FD = 14
ZMQ_EVENTS = 15
ZMQ_TYPE = 16
ZMQ_LINGER = 17
ZMQ_RECONNECT_IVL = 18
ZMQ_BACKLOG = 19
ZMQ_RECOVERY_IVL_MSEC = 20
ZMQ_RECONNECT_IVL_MAX = 21
ZMQ_RCVTIMEO = 27
ZMQ_SNDTIMEO = 28

ZMQ_NOBLOCK = 1
ZMQ_SNDMORE = 2

if zmq_version == 2:
    uint64_opts = [ZMQ_HWM, ZMQ_AFFINITY, ZMQ_SNDBUF, ZMQ_RCVBUF]

    int64_opts =  [ZMQ_SWAP, ZMQ_RECOVERY_IVL, ZMQ_RECOVERY_IVL_MSEC,
                   ZMQ_MCAST_LOOP, ZMQ_RATE]

    binary_opts = [ZMQ_IDENTITY, ZMQ_SUBSCRIBE, ZMQ_UNSUBSCRIBE]

    int_opts =    [ZMQ_RCVTIMEO, ZMQ_SNDTIMEO, ZMQ_LINGER, ZMQ_RECONNECT_IVL,
                   ZMQ_RECONNECT_IVL_MAX, ZMQ_BACKLOG]
else:
    uint64_opts = [ZMQ_AFFINITY, ZMQ_SNDBUF, ZMQ_RCVBUF]

    int64_opts =  [ZMQ_SWAP, ZMQ_RECOVERY_IVL, ZMQ_RECOVERY_IVL_MSEC,
                   ZMQ_MCAST_LOOP]

    binary_opts = [ZMQ_IDENTITY, ZMQ_SUBSCRIBE, ZMQ_UNSUBSCRIBE]

    int_opts =    [ZMQ_RCVHWM, ZMQ_SNDHWM, ZMQ_RCVTIMEO, ZMQ_SNDTIMEO,
                   ZMQ_LINGER, ZMQ_RECONNECT_IVL, ZMQ_RECONNECT_IVL_MAX,
                   ZMQ_BACKLOG, ZMQ_RATE]
