##############################################################################
#
# Copyright (c) 2006 Zope Corporation and Contributors.
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#
##############################################################################
"""Setup for zope.app.publication package

$Id: setup.py 80091 2007-09-26 07:59:19Z ctheune $
"""

import os

from setuptools import setup, find_packages

def read(*rnames):
    return open(os.path.join(os.path.dirname(__file__), *rnames)).read()

setup(name='zope.app.publication',
    version = '3.4.2',
    author='Zope Corporation and Contributors',
    author_email='zope3-dev@zope.org',
    description='Zope publication',
    long_description=(
        read('README.txt')
        + '\n\n' +
        read('CHANGES.txt')
        ),
    license='ZPL 2.1',
    keywords = "zope3 publication",
    classifiers = [
        'Development Status :: 5 - Production/Stable',
        'Environment :: Web Environment',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: Zope Public License',
        'Programming Language :: Python',
        'Natural Language :: English',
        'Operating System :: OS Independent',
        'Topic :: Internet :: WWW/HTTP',
        'Framework :: Zope3'],
    url='http://cheeseshop.python.org/pypi/zope.app.publication',
    packages=find_packages('src'),
    package_dir = {'': 'src'},
    namespace_packages=['zope', 'zope.app'],
    extras_require = dict(
        test=['zope.app.testing',
              'zope.app.securitypolicy',
              'zope.app.zcmlfiles',
              'zope.app.dav',
              'zope.app.zptpage',
              ]),
    install_requires=['zope.interface',
                      'ZODB3',
                      'zope.component',
                      'zope.error',
                      'zope.i18n',
                      'zope.app.http',
                      'zope.app.applicationcontrol',
                      'zope.app.error',
                      'zope.app.exception',
                      'zope.app.security',
                      'setuptools',
                      ],
    include_package_data = True,
    zip_safe = False,
    )
