##############################################################################
#
# Copyright (c) 2001, 2002 Zope Corporation and Contributors.
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#
##############################################################################
"""
$Id: __init__.py 98094 2009-03-14 15:50:25Z nadako $
"""
from zope.interface import implements
from zope.authentication.interfaces import IAuthentication, PrincipalLookupError
from zope.security.interfaces import IPrincipal

class DummyPrincipalRegistry(object):
    """Dummy principal registry that only implements getPrincipal
    and definePrincipal method that are needed for securitypolicy tests."""
    
    implements(IAuthentication)
    
    def __init__(self):
        self._principals = {}
        
    def getPrincipal(self, id):
        if id not in self._principals:
            raise PrincipalLookupError(id)
        return self._principals[id]

    def definePrincipal(self, id, title=u'', description=u''):
        p = DummyPrincipal(id, title, description)
        self._principals[id] = p
        return p

principalRegistry = DummyPrincipalRegistry()

class DummyPrincipal(object):
    """Very simple principal implementation"""
    
    implements(IPrincipal)
    
    def __init__(self, id, title=u'', description=u''):
        self.id = id
        self.title = title
        self.description = description
