/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.Serializable;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.ErrorHandler;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LifeCycle;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.DefaultErrorHandler;
import org.apache.logging.log4j.core.filter.AbstractFilterable;
import org.apache.logging.log4j.status.StatusLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAppender<T extends Serializable>
extends AbstractFilterable
implements Appender<T>,
LifeCycle {
    protected static final Logger LOGGER = StatusLogger.getLogger();
    private boolean started = false;
    private final Layout<T> layout;
    private final String name;
    private final boolean handleException;
    private ErrorHandler handler = new DefaultErrorHandler(this);

    protected AbstractAppender(String name, Filter filter, Layout<T> layout) {
        this(name, filter, layout, true);
    }

    protected AbstractAppender(String name, Filter filter, Layout<T> layout, boolean handleException) {
        super(filter);
        this.name = name;
        this.layout = layout;
        this.handleException = handleException;
    }

    @Override
    public ErrorHandler getHandler() {
        return this.handler;
    }

    @Override
    public void setHandler(ErrorHandler handler) {
        if (handler == null) {
            LOGGER.error("The handler cannot be set to null");
        }
        if (this.isStarted()) {
            LOGGER.error("The handler cannot be changed once the appender is started");
            return;
        }
        this.handler = handler;
    }

    public void close() {
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Layout<T> getLayout() {
        return this.layout;
    }

    @Override
    public boolean isExceptionSuppressed() {
        return this.handleException;
    }

    @Override
    public void start() {
        this.startFilter();
        this.started = true;
    }

    @Override
    public void stop() {
        this.started = false;
        this.stopFilter();
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    public String toString() {
        return this.name;
    }

    public void error(String msg) {
        this.handler.error(msg);
    }

    public void error(String msg, Throwable t) {
        this.handler.error(msg, t);
    }

    public void error(String msg, LogEvent event, Throwable t) {
        this.handler.error(msg, event, t);
    }
}

