/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttr;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.filter.ThresholdFilter;
import org.apache.logging.log4j.core.layout.HTMLLayout;
import org.apache.logging.log4j.core.net.SMTPManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Plugin(name="SMTP", type="Core", elementType="appender", printObject=true)
public final class SMTPAppender
extends AbstractAppender {
    private static final int DEFAULT_BUFFER_SIZE = 512;
    protected final SMTPManager manager;

    private SMTPAppender(String name, Filter filter, Layout<?> layout, SMTPManager manager, boolean handleExceptions) {
        super(name, filter, layout, handleExceptions);
        this.manager = manager;
    }

    @PluginFactory
    public static SMTPAppender createAppender(@PluginAttr(value="name") String name, @PluginAttr(value="to") String to, @PluginAttr(value="cc") String cc, @PluginAttr(value="bcc") String bcc, @PluginAttr(value="from") String from, @PluginAttr(value="replyTo") String replyTo, @PluginAttr(value="subject") String subject, @PluginAttr(value="smtpProtocol") String smtpProtocol, @PluginAttr(value="smtpHost") String smtpHost, @PluginAttr(value="smtpPort") String smtpPortNum, @PluginAttr(value="smtpUsername") String smtpUsername, @PluginAttr(value="smtpPassword") String smtpPassword, @PluginAttr(value="smtpDebug") String smtpDebug, @PluginAttr(value="bufferSize") String bufferSizeNum, @PluginElement(value="layout") Layout<?> layout, @PluginElement(value="filter") Filter filter, @PluginAttr(value="suppressExceptions") String suppressExceptions) {
        SMTPManager manager;
        int bufferSize;
        if (name == null) {
            LOGGER.error("No name provided for SMTPAppender");
            return null;
        }
        boolean isHandleExceptions = suppressExceptions == null ? true : Boolean.valueOf(suppressExceptions);
        int smtpPort = smtpPortNum == null ? 0 : Integer.parseInt(smtpPortNum);
        boolean isSmtpDebug = smtpDebug == null ? false : Boolean.valueOf(smtpDebug);
        int n = bufferSize = bufferSizeNum == null ? 512 : Integer.valueOf(bufferSizeNum);
        if (layout == null) {
            layout = HTMLLayout.createLayout(null, null, null, null, null, null);
        }
        if (filter == null) {
            filter = ThresholdFilter.createFilter(null, null, null);
        }
        if ((manager = SMTPManager.getSMTPManager(to, cc, bcc, from, replyTo, subject, smtpProtocol, smtpHost, smtpPort, smtpUsername, smtpPassword, isSmtpDebug, filter.toString(), bufferSize)) == null) {
            return null;
        }
        return new SMTPAppender(name, filter, layout, manager, isHandleExceptions);
    }

    @Override
    public boolean isFiltered(LogEvent event) {
        boolean filtered = super.isFiltered(event);
        if (filtered) {
            this.manager.add(event);
        }
        return filtered;
    }

    @Override
    public void append(LogEvent event) {
        this.manager.sendEvents(this.getLayout(), event);
    }
}

