/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.appender.AbstractOutputStreamAppender;
import org.apache.logging.log4j.core.appender.ManagerFactory;
import org.apache.logging.log4j.core.appender.OutputStreamManager;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttr;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.helpers.Loader;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.util.PropertiesUtil;

@Plugin(name="Console", type="Core", elementType="appender", printObject=true)
public final class ConsoleAppender
extends AbstractOutputStreamAppender {
    private static ConsoleManagerFactory factory = new ConsoleManagerFactory();

    private ConsoleAppender(String name, Layout layout, Filter filter, OutputStreamManager manager, boolean handleExceptions) {
        super(name, layout, filter, handleExceptions, true, manager);
    }

    @PluginFactory
    public static ConsoleAppender createAppender(@PluginElement(value="layout") Layout layout, @PluginElement(value="filters") Filter filter, @PluginAttr(value="target") String t, @PluginAttr(value="name") String name, @PluginAttr(value="follow") String follow, @PluginAttr(value="suppressExceptions") String suppress) {
        if (name == null) {
            LOGGER.error("No name provided for ConsoleAppender");
            return null;
        }
        if (layout == null) {
            layout = PatternLayout.createLayout(null, null, null, null);
        }
        boolean isFollow = follow == null ? false : Boolean.valueOf(follow);
        boolean handleExceptions = suppress == null ? true : Boolean.valueOf(suppress);
        Target target = t == null ? Target.SYSTEM_OUT : Target.valueOf(t);
        return new ConsoleAppender(name, layout, filter, ConsoleAppender.getManager(isFollow, target), handleExceptions);
    }

    private static OutputStreamManager getManager(boolean follow, Target target) {
        String type = target.name();
        OutputStream os = ConsoleAppender.getOutputStream(follow, target);
        return OutputStreamManager.getManager(target.name() + "." + follow, new FactoryData(os, type), factory);
    }

    private static OutputStream getOutputStream(boolean follow, Target target) {
        PrintStream printStream = target == Target.SYSTEM_OUT ? (follow ? new PrintStream(new SystemOutStream()) : System.out) : (follow ? new PrintStream(new SystemErrStream()) : System.err);
        PropertiesUtil propsUtil = PropertiesUtil.getProperties();
        if (!propsUtil.getStringProperty("os.name").startsWith("Windows") || propsUtil.getBooleanProperty("log4j.skipJansi")) {
            return printStream;
        }
        try {
            ClassLoader loader = Loader.getClassLoader();
            Class<?> clazz = loader.loadClass("org.fusesource.jansi.WindowsAnsiOutputStream");
            Constructor<?> constructor = clazz.getConstructor(OutputStream.class);
            return (OutputStream)constructor.newInstance(printStream);
        }
        catch (ClassNotFoundException cnfe) {
            LOGGER.debug("Jansi is not installed");
        }
        catch (NoSuchMethodException nsme) {
            LOGGER.warn("WindowsAnsiOutputStream is missing the proper constructor");
        }
        catch (Exception ex) {
            LOGGER.warn("Unable to instantiate WindowsAnsiOutputStream");
        }
        return printStream;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConsoleManagerFactory
    implements ManagerFactory<OutputStreamManager, FactoryData> {
        private ConsoleManagerFactory() {
        }

        @Override
        public OutputStreamManager createManager(String name, FactoryData data) {
            return new OutputStreamManager(data.os, data.type);
        }
    }

    private static class FactoryData {
        private final OutputStream os;
        private final String type;

        public FactoryData(OutputStream os, String type) {
            this.os = os;
            this.type = type;
        }
    }

    private static class SystemOutStream
    extends OutputStream {
        public void close() {
        }

        public void flush() {
            System.out.flush();
        }

        public void write(byte[] b) throws IOException {
            System.out.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            System.out.write(b, off, len);
        }

        public void write(int b) throws IOException {
            System.out.write(b);
        }
    }

    private static class SystemErrStream
    extends OutputStream {
        public void close() {
        }

        public void flush() {
            System.err.flush();
        }

        public void write(byte[] b) throws IOException {
            System.err.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            System.err.write(b, off, len);
        }

        public void write(int b) {
            System.err.write(b);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Target {
        SYSTEM_OUT,
        SYSTEM_ERR;

    }
}

