/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config;

import java.io.Serializable;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AppenderRuntimeException;
import org.apache.logging.log4j.core.filter.AbstractFilterable;
import org.apache.logging.log4j.core.filter.Filterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppenderControl<T extends Serializable>
extends AbstractFilterable {
    private final ThreadLocal<AppenderControl<T>> recursive = new ThreadLocal();
    private final Appender<T> appender;
    private final Level level;
    private final int intLevel;

    public AppenderControl(Appender<T> appender, Level level, Filter filter) {
        super(filter);
        this.appender = appender;
        this.level = level;
        this.intLevel = level == null ? Level.ALL.intLevel() : level.intLevel();
        this.startFilter();
    }

    public Appender<T> getAppender() {
        return this.appender;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callAppender(LogEvent event) {
        Filter.Result r;
        if (this.getFilter() != null && (r = this.getFilter().filter(event)) == Filter.Result.DENY) {
            return;
        }
        if (this.level != null && this.intLevel < event.getLevel().intLevel()) {
            return;
        }
        if (this.recursive.get() != null) {
            this.appender.getHandler().error("Recursive call to appender " + this.appender.getName());
            return;
        }
        try {
            this.recursive.set(this);
            if (!this.appender.isStarted()) {
                this.appender.getHandler().error("Attempted to append to non-started appender " + this.appender.getName());
                if (!this.appender.isExceptionSuppressed()) {
                    throw new AppenderRuntimeException("Attempted to append to non-started appender " + this.appender.getName());
                }
            }
            if (this.appender instanceof Filterable && ((Filterable)((Object)this.appender)).isFiltered(event)) {
                return;
            }
            try {
                this.appender.append(event);
            }
            catch (RuntimeException ex) {
                this.appender.getHandler().error("An exception occurred processing Appender " + this.appender.getName(), ex);
                if (!this.appender.isExceptionSuppressed()) {
                    throw ex;
                }
            }
            catch (Exception ex) {
                this.appender.getHandler().error("An exception occurred processing Appender " + this.appender.getName(), ex);
                if (!this.appender.isExceptionSuppressed()) {
                    throw new AppenderRuntimeException(ex);
                }
            }
        }
        finally {
            this.recursive.set(null);
        }
    }
}

